/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.runtime;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.client.renderer.ISerializableRenderer;
import com.lowdragmc.lowdraglib.gui.editor.accessors.IConfiguratorAccessor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigAccessor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegisterClient;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.editor.data.IProject;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.ui.menu.MenuTab;
import com.lowdragmc.lowdraglib.gui.editor.ui.view.FloatViewWidget;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.test.ui.IUITest;
import com.lowdragmc.lowdraglib.utils.ReflectionUtils;
import com.lowdragmc.lowdraglib.utils.TypeAdapter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class AnnotationDetector {
    public static final List<IConfiguratorAccessor<?>> CONFIGURATOR_ACCESSORS = AnnotationDetector.scanClasses(ConfigAccessor.class, IConfiguratorAccessor.class, AnnotationDetector::checkNoArgsConstructor, AnnotationDetector::createNoArgsInstance, (a, b) -> 0, l -> {});
    public static final List<Wrapper<LDLRegister, IGuiTexture>> REGISTER_TEXTURES = AnnotationDetector.scanClasses(LDLRegister.class, IGuiTexture.class, AnnotationDetector::checkNoArgsConstructor, AnnotationDetector::toUINoArgsBuilder, AnnotationDetector::UIWrapperSorter, l -> {});
    public static final List<Wrapper<LDLRegister, Resource>> REGISTER_RESOURCES = AnnotationDetector.scanClasses(LDLRegister.class, Resource.class, AnnotationDetector::checkNoArgsConstructor, AnnotationDetector::toUINoArgsBuilder, AnnotationDetector::UIWrapperSorter, l -> {});
    public static final List<Wrapper<LDLRegister, IConfigurableWidget>> REGISTER_WIDGETS = AnnotationDetector.scanClasses(LDLRegister.class, IConfigurableWidget.class, AnnotationDetector::checkNoArgsConstructor, AnnotationDetector::toUINoArgsBuilder, AnnotationDetector::UIWrapperSorter, l -> {});
    public static final List<Wrapper<LDLRegister, FloatViewWidget>> REGISTER_FLOAT_VIEWS = AnnotationDetector.scanClasses(LDLRegister.class, FloatViewWidget.class, AnnotationDetector::checkNoArgsConstructor, AnnotationDetector::toUINoArgsBuilder, AnnotationDetector::UIWrapperSorter, l -> {});
    public static final List<Wrapper<LDLRegister, MenuTab>> REGISTER_MENU_TABS = AnnotationDetector.scanClasses(LDLRegister.class, MenuTab.class, AnnotationDetector::checkNoArgsConstructor, AnnotationDetector::toUINoArgsBuilder, AnnotationDetector::UIWrapperSorter, l -> {});
    public static final List<Wrapper<LDLRegister, IProject>> REGISTER_PROJECTS = AnnotationDetector.scanClasses(LDLRegister.class, IProject.class, AnnotationDetector::checkNoArgsConstructor, AnnotationDetector::toUINoArgsBuilder, AnnotationDetector::UIWrapperSorter, l -> {});
    public static final Map<String, Wrapper<LDLRegisterClient, ? extends ISerializableRenderer>> REGISTER_RENDERERS = new HashMap<String, Wrapper<LDLRegisterClient, ? extends ISerializableRenderer>>();
    public static final List<Wrapper<LDLRegisterClient, IUITest>> REGISTER_UI_TESTS = new ArrayList<Wrapper<LDLRegisterClient, IUITest>>();
    public static final List<TypeAdapter.ITypeAdapter> REGISTER_TYPE_ADAPTERS = AnnotationDetector.scanClasses(LDLRegister.class, TypeAdapter.ITypeAdapter.class, AnnotationDetector::checkNoArgsConstructor, AnnotationDetector::createNoArgsInstance, (a, b) -> 0, l -> {});
    public static final Map<String, Wrapper<LDLRegister, ? extends BaseNode>> REGISTER_GP_NODES = new HashMap<String, Wrapper<LDLRegister, ? extends BaseNode>>();

    public static void init() {
        if (LDLib.isClient()) {
            AnnotationDetector.scanClasses(LDLRegisterClient.class, ISerializableRenderer.class, AnnotationDetector::checkNoArgsConstructor, AnnotationDetector::toClientUINoArgsBuilder, AnnotationDetector::clientUIWrapperSorter, l -> REGISTER_RENDERERS.putAll(l.stream().collect(Collectors.toMap(w -> ((LDLRegisterClient)w.annotation()).name(), w -> w))));
            if (Platform.isDevEnv()) {
                AnnotationDetector.scanClasses(LDLRegisterClient.class, IUITest.class, AnnotationDetector::checkNoArgsConstructor, AnnotationDetector::toClientUINoArgsBuilder, AnnotationDetector::clientUIWrapperSorter, l -> {
                    for (Wrapper wrapper : l) {
                        REGISTER_UI_TESTS.add(wrapper);
                    }
                });
            }
        }
        AnnotationDetector.scanClasses(LDLRegister.class, BaseNode.class, AnnotationDetector::checkNoArgsConstructor, AnnotationDetector::toUINoArgsBuilder, AnnotationDetector::UIWrapperSorter, l -> REGISTER_GP_NODES.putAll(l.stream().collect(Collectors.toMap(w -> ((LDLRegister)w.annotation()).name(), w -> w))));
    }

    public static <A extends Annotation, T, C> List<C> scanClasses(Class<A> annotationClass, Class<T> baseClazz, BiPredicate<A, Class<? extends T>> predicate, Function<Class<? extends T>, C> mapping, Comparator<C> sorter, Consumer<List<C>> onFinished) {
        ArrayList result = new ArrayList();
        ReflectionUtils.findAnnotationClasses(annotationClass, clazz -> {
            if (baseClazz.isAssignableFrom((Class<?>)clazz)) {
                try {
                    Class realClass = clazz;
                    if (predicate.test(clazz.getAnnotation(annotationClass), realClass)) {
                        result.add(mapping.apply(realClass));
                    }
                }
                catch (Throwable e) {
                    LDLib.LOGGER.error("failed to scan annotation {} + base class {} while handling class {} ", new Object[]{annotationClass, baseClazz, clazz, e});
                }
            }
        }, () -> {
            result.sort(sorter);
            onFinished.accept(result);
        });
        return result;
    }

    public static <A, T> boolean checkNoArgsConstructor(A annotation, Class<? extends T> clazz) {
        LDLRegisterClient LDLRegisterClient2;
        LDLRegister LDLRegister2;
        if (annotation instanceof LDLRegister ? !(LDLRegister2 = (LDLRegister)annotation).modID().isEmpty() && !LDLib.isModLoaded(LDLRegister2.modID()) : annotation instanceof LDLRegisterClient && !(LDLRegisterClient2 = (LDLRegisterClient)annotation).modID().isEmpty() && !LDLib.isModLoaded(LDLRegisterClient2.modID())) {
            return false;
        }
        try {
            clazz.getDeclaredConstructor(new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static <T> T createNoArgsInstance(Class<? extends T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Wrapper<LDLRegister, T> toUINoArgsBuilder(Class<? extends T> clazz) {
        return new Wrapper<LDLRegister, Object>(clazz.getAnnotation(LDLRegister.class), clazz, () -> AnnotationDetector.createNoArgsInstance(clazz));
    }

    public static int UIWrapperSorter(Wrapper<LDLRegister, ?> a, Wrapper<LDLRegister, ?> b) {
        return ((LDLRegister)b.annotation).priority() - ((LDLRegister)a.annotation).priority();
    }

    public static <T> Wrapper<LDLRegisterClient, T> toClientUINoArgsBuilder(Class<? extends T> clazz) {
        return new Wrapper<LDLRegisterClient, Object>(clazz.getAnnotation(LDLRegisterClient.class), clazz, () -> AnnotationDetector.createNoArgsInstance(clazz));
    }

    public static int clientUIWrapperSorter(Wrapper<LDLRegisterClient, ?> a, Wrapper<LDLRegisterClient, ?> b) {
        return b.annotation().priority() - a.annotation().priority();
    }

    public record Wrapper<A extends Annotation, T>(A annotation, Class<? extends T> clazz, Supplier<T> creator) {
    }
}

