/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.data;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.editor.data.IProject;
import com.lowdragmc.lowdraglib.gui.editor.data.Resources;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.editor.ui.MainPanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.tool.WidgetToolBox;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.io.File;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

@LDLRegister(name="ui", group="editor.ui")
public class UIProject
implements IProject {
    public Resources resources;
    public WidgetGroup root;

    private UIProject() {
    }

    public UIProject(Resources resources, WidgetGroup root) {
        this.resources = resources;
        this.root = root;
    }

    public UIProject(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    @Override
    public UIProject newEmptyProject() {
        return new UIProject(Resources.defaultResource(), (WidgetGroup)new WidgetGroup(30, 30, 200, 200).setBackground(ResourceBorderTexture.BORDERED_BACKGROUND));
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("resources", (Tag)this.resources.serializeNBT());
        tag.m_128365_("root", (Tag)IConfigurableWidget.serializeNBT((IConfigurableWidget)this.root, this.resources, true));
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        this.resources = this.loadResources(tag.m_128469_("resources"));
        this.root = new WidgetGroup();
        IConfigurableWidget.deserializeNBT((IConfigurableWidget)this.root, tag.m_128469_("root"), this.resources, true);
    }

    @Override
    public Resources getResources() {
        return this.resources;
    }

    @Override
    public void onLoad(Editor editor) {
        IProject.super.onLoad(editor);
        editor.getTabPages().addTab("Main", (WidgetGroup)new MainPanel(editor, this.root));
        for (WidgetToolBox.Default tab : WidgetToolBox.Default.TABS) {
            editor.getToolPanel().addNewToolBox("ldlib.gui.editor.group." + tab.groupName, tab.icon, tab::createToolBox);
        }
    }

    public static Supplier<WidgetGroup> loadUIFromTag(CompoundTag tag) {
        Resources resources = Resources.fromNBT(tag.m_128469_("resources"));
        CompoundTag data = tag.m_128469_("root");
        return () -> {
            WidgetGroup root = new WidgetGroup();
            IConfigurableWidget.deserializeNBT((IConfigurableWidget)root, data, resources, false);
            return root;
        };
    }

    @Nullable
    public static Supplier<WidgetGroup> loadUIFromFile(ResourceLocation location) {
        try {
            File file = new File(LDLib.getLDLibDir(), "assets/%s/projects/ui/%s.ui".formatted(location.m_135827_(), location.m_135815_()));
            return UIProject.loadUIFromTag(NbtIo.m_128953_((File)file));
        }
        catch (Exception e) {
            LDLib.LOGGER.error("Failed to load ui project from file: {}", (Object)location, (Object)e);
            return null;
        }
    }
}

