/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.configurator.NumberConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ValueConfigurator;
import com.lowdragmc.lowdraglib.utils.Range;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class RangeConfigurator
extends ValueConfigurator<Range> {
    protected Number min;
    protected Number max;
    protected Number wheel;

    public RangeConfigurator(String name, Supplier<Range> supplier, Consumer<Range> onUpdate, Range defaultValue, boolean forceUpdate) {
        super(name, supplier, onUpdate, defaultValue, forceUpdate);
        if (this.value == null) {
            this.value = defaultValue;
        }
        boolean isDecimal = ((Range)this.value).getA() instanceof Double || ((Range)this.value).getB() instanceof Double || ((Range)this.value).getA() instanceof Float || ((Range)this.value).getB() instanceof Float;
        this.setRange(Math.min(((Range)this.value).getA().doubleValue(), ((Range)this.value).getB().doubleValue()), Math.max(((Range)this.value).getA().doubleValue(), ((Range)this.value).getB().doubleValue()));
        if (isDecimal) {
            this.setWheel(0.1);
        } else {
            this.setWheel(1);
        }
    }

    public RangeConfigurator setRange(Number min, Number max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public RangeConfigurator setWheel(Number wheel) {
        if (wheel.doubleValue() == 0.0) {
            return this;
        }
        this.wheel = wheel;
        return this;
    }

    @Override
    protected void onValueUpdate(Range newValue) {
        if (newValue == null) {
            newValue = (Range)this.defaultValue;
        }
        if (newValue.equals(this.value)) {
            return;
        }
        super.onValueUpdate(newValue);
    }

    @Override
    public void init(int width) {
        super.init(width);
        assert (this.value != null);
        int w = (width - this.leftWidth - this.rightWidth) / 2;
        NumberConfigurator x = new NumberConfigurator("", () -> ((Range)this.value).getA(), number -> {
            ((Range)this.value).setA((Number)number);
            this.updateValue();
        }, ((Range)this.defaultValue).getA(), this.forceUpdate);
        x.setRange(this.min, this.max);
        x.setWheel(this.wheel);
        x.setConfiguratorContainer(this.configuratorContainer);
        x.init(w);
        x.addSelfPosition(this.leftWidth, 0);
        this.addWidget(x);
        NumberConfigurator y = new NumberConfigurator("", () -> ((Range)this.value).getB(), number -> {
            ((Range)this.value).setB((Number)number);
            this.updateValue();
        }, ((Range)this.defaultValue).getB(), this.forceUpdate);
        y.setRange(this.min, this.max);
        y.setWheel(this.wheel);
        y.setConfiguratorContainer(this.configuratorContainer);
        y.init(w);
        y.addSelfPosition(this.leftWidth + w, 0);
        this.addWidget(y);
    }
}

