/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ValueConfigurator;
import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class NumberConfigurator
extends ValueConfigurator<Number> {
    protected boolean isDecimal;
    protected TextFieldWidget textFieldWidget;
    protected ImageWidget image;
    protected Number min;
    protected Number max;
    protected Number wheel;
    protected boolean colorBackground;

    public NumberConfigurator(String name, Supplier<Number> supplier, Consumer<Number> onUpdate, @Nonnull Number defaultValue, boolean forceUpdate) {
        super(name, supplier, onUpdate, defaultValue, forceUpdate);
        if (this.value == null) {
            this.value = defaultValue;
        }
        this.isDecimal = this.value instanceof Double || this.value instanceof Float;
        this.setRange((Number)this.value, (Number)this.value);
        if (this.isDecimal) {
            this.setWheel(0.1);
        } else {
            this.setWheel(1);
        }
    }

    public NumberConfigurator setRange(Number min, Number max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public NumberConfigurator setWheel(Number wheel) {
        if (wheel.doubleValue() == 0.0) {
            return this;
        }
        this.wheel = wheel;
        return this;
    }

    @Override
    protected void onValueUpdate(Number newValue) {
        if (newValue == null) {
            newValue = (Number)this.defaultValue;
        }
        if (newValue.equals(this.value)) {
            return;
        }
        super.onValueUpdate(newValue);
        if (this.isDecimal) {
            this.textFieldWidget.setCurrentString(Float.valueOf(((Number)this.value).floatValue()));
        } else {
            this.textFieldWidget.setCurrentString(((Number)this.value).longValue());
        }
    }

    private IGuiTexture getCommonColor() {
        return this.colorBackground ? new ColorRectTexture(((Number)this.value).intValue()).setRadius(5.0f).setRadius(5.0f) : ColorPattern.T_GRAY.rectTexture().setRadius(5.0f);
    }

    @Override
    public void init(int width) {
        super.init(width);
        this.image = new ImageWidget(this.leftWidth, 2, width - this.leftWidth - 3 - this.rightWidth, 10, this.getCommonColor());
        this.addWidget(this.image);
        this.image.setDraggingConsumer(o -> o instanceof Number, o -> this.image.setImage(ColorPattern.GREEN.rectTexture().setRadius(5.0f)), o -> this.image.setImage(this.getCommonColor()), o -> {
            if (o instanceof Number) {
                Number number = (Number)o;
                this.onValueUpdate(number);
                this.updateValue();
            }
            this.image.setImage(this.getCommonColor());
        });
        this.textFieldWidget = new TextFieldWidget(this.leftWidth + 3, 2, width - this.leftWidth - 6 - this.rightWidth, 10, null, this::onNumberUpdate);
        this.addWidget(this.textFieldWidget);
        this.textFieldWidget.setClientSideWidget();
        if (this.isDecimal) {
            this.textFieldWidget.setCurrentString(Float.valueOf(((Number)this.value).floatValue()));
        } else {
            this.textFieldWidget.setCurrentString(((Number)this.value).longValue());
        }
        this.textFieldWidget.setBordered(false);
        if (this.isDecimal) {
            this.textFieldWidget.setNumbersOnly(this.min.floatValue(), this.max.floatValue());
        } else {
            this.textFieldWidget.setNumbersOnly(this.min.longValue(), this.max.longValue());
        }
        this.textFieldWidget.setWheelDur(this.wheel.floatValue());
    }

    private void onNumberUpdate(String s) {
        Number newValue = this.isDecimal ? (Number)Double.parseDouble(s) : (Number)Long.parseLong(s);
        if (this.value instanceof Integer && !((Number)this.value).equals(newValue.intValue())) {
            this.value = newValue.intValue();
            this.updateValue();
        } else if (this.value instanceof Long && !((Number)this.value).equals(newValue.longValue())) {
            this.value = newValue.longValue();
            this.updateValue();
        } else if (this.value instanceof Float && !((Number)this.value).equals(Float.valueOf(newValue.floatValue()))) {
            this.value = Float.valueOf(newValue.floatValue());
            this.updateValue();
        } else if (this.value instanceof Double && !((Number)this.value).equals(newValue.doubleValue())) {
            this.value = newValue.doubleValue();
            this.updateValue();
        } else if (this.value instanceof Byte && !((Number)this.value).equals(newValue.byteValue())) {
            this.value = newValue.byteValue();
            this.updateValue();
        } else if (this.value == null) {
            this.value = this.isDecimal ? (Number)Float.valueOf(newValue.floatValue()) : (Number)newValue.intValue();
            this.updateValue();
        }
        if (this.colorBackground) {
            this.image.setImage(this.getCommonColor());
        }
    }

    public void setColorBackground(boolean colorBackground) {
        this.colorBackground = colorBackground;
    }
}

