/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ValueConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIContainer;
import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.HsbColorWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.utils.Position;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ColorConfigurator
extends ValueConfigurator<Number> {
    protected ImageWidget image;
    protected boolean colorBackground;

    public ColorConfigurator(String name, Supplier<Number> supplier, Consumer<Number> onUpdate, @Nonnull Number defaultValue, boolean forceUpdate) {
        super(name, supplier, onUpdate, defaultValue, forceUpdate);
        if (this.value == null) {
            this.value = defaultValue;
        }
    }

    @Override
    protected void onValueUpdate(Number newValue) {
        if (newValue == null) {
            newValue = (Number)this.defaultValue;
        }
        if (newValue.equals(this.value)) {
            return;
        }
        super.onValueUpdate(newValue);
        this.image.setImage(this.getCommonColor());
    }

    private IGuiTexture getCommonColor() {
        return new GuiTextureGroup(new ColorRectTexture(((Number)this.value).intValue()).setRadius(5.0f).setRadius(5.0f), new ColorBorderTexture(ColorPattern.WHITE.color, -1).setRadius(5.0f));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 1 && Editor.INSTANCE != null && this.image.isMouseOverElement(mouseX, mouseY)) {
            TreeBuilder.Menu menu = TreeBuilder.Menu.start().leaf(Icons.COPY, "ldlib.gui.editor.menu.copy", () -> Editor.INSTANCE.setCopy("number", this.value));
            if ("number".equals(Editor.INSTANCE.getCopyType())) {
                menu.leaf(Icons.PASTE, "ldlib.gui.editor.menu.paste", () -> Editor.INSTANCE.ifCopiedPresent("number", c -> {
                    if (c instanceof Number) {
                        Number number = (Number)c;
                        this.onValueUpdate(number.intValue());
                        this.updateValue();
                    }
                }));
            }
            Editor.INSTANCE.openMenu(mouseX, mouseY, menu);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public void init(int width) {
        super.init(width);
        this.image = new ImageWidget(this.leftWidth, 2, width - this.leftWidth - 3 - this.rightWidth, 10, this.getCommonColor());
        this.addWidget(this.image);
        this.image.setDraggingConsumer(o -> o instanceof Number, o -> this.image.setImage(ColorPattern.GREEN.rectTexture().setRadius(5.0f)), o -> this.image.setImage(this.getCommonColor()), o -> {
            if (o instanceof Number) {
                Number number = (Number)o;
                this.onValueUpdate(number.intValue());
                this.updateValue();
            }
        });
        this.addWidget(new ButtonWidget(this.leftWidth, 2, width - this.leftWidth - 3 - this.rightWidth, 10, null, cd -> {
            Position position = this.image.getPosition();
            int rightPlace = this.getGui().getScreenWidth() - 110;
            DialogWidget dialog = new DialogWidget(Math.min(position.x, rightPlace), position.y - 110, 110, 110);
            dialog.setClickClose(true);
            dialog.addWidget(new HsbColorWidget(5, 5, 100, 100).setOnChanged(newColor -> {
                this.value = newColor;
                this.updateValue();
                this.image.setImage(this.getCommonColor());
            }).setColorSupplier(() -> ((Number)this.value).intValue()).setColor(((Number)this.value).intValue())).setBackground(new GuiTextureGroup(ColorPattern.BLACK.rectTexture(), ColorPattern.T_WHITE.borderTexture(-1)));
            if (Editor.INSTANCE != null) {
                Editor.INSTANCE.openDialog(dialog);
            } else {
                AbstractContainerMenu patt4928$temp = Minecraft.m_91087_().f_91074_.f_36096_;
                if (patt4928$temp instanceof ModularUIContainer) {
                    ModularUIContainer container = (ModularUIContainer)patt4928$temp;
                    container.getModularUI().mainGroup.addWidget(dialog);
                }
            }
        }));
    }

    public void setColorBackground(boolean colorBackground) {
        this.colorBackground = colorBackground;
    }
}

