/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.configurator.ValueConfigurator;
import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class BooleanConfigurator
extends ValueConfigurator<Boolean> {
    protected SwitchWidget switchWidget;

    public BooleanConfigurator(String name, Supplier<Boolean> supplier, Consumer<Boolean> onUpdate, @Nonnull Boolean defaultValue, boolean forceUpdate) {
        super(name, supplier, onUpdate, defaultValue, forceUpdate);
        if (this.value == null) {
            this.value = defaultValue;
        }
    }

    @Override
    protected void onValueUpdate(Boolean newValue) {
        if (newValue == null) {
            newValue = (Boolean)this.defaultValue;
        }
        if (newValue.equals(this.value)) {
            return;
        }
        super.onValueUpdate(newValue);
        this.switchWidget.setPressed(newValue);
    }

    @Override
    public void init(int width) {
        super.init(width);
        this.switchWidget = new SwitchWidget(this.leftWidth, 2, 10, 10, (cd, pressed) -> {
            this.value = pressed;
            this.updateValue();
        });
        this.addWidget(this.switchWidget);
        this.switchWidget.setPressed((Boolean)this.value);
        this.switchWidget.setTexture(new ColorBorderTexture(-1, -1).setRadius(5.0f), new GuiTextureGroup(new ColorBorderTexture(-1, -1).setRadius(5.0f), new ColorRectTexture(-1).setRadius(5.0f).scale(0.5f)));
    }
}

