/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor;

import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.utils.ColorUtils;

public enum ColorPattern {
    WHITE(-1),
    T_WHITE(-1996488705),
    BLACK(-14540254),
    T_BLACK(0x44222222),
    SEAL_BLACK(-13552072),
    T_SEAL_BLACK(-2010040776),
    GRAY(-10066330),
    T_GRAY(0x66666666),
    DARK_GRAY(-12303292),
    T_DARK_GRAY(0x44444444),
    LIGHT_GRAY(-5592406),
    T_LIGHT_GRAY(-2002081110),
    GREEN(-13369600),
    T_GREEN(-2009858304),
    RED(-6487774),
    T_RED(-2002976478),
    BRIGHT_RED(-65536),
    T_BRIGHT_RED(-1996554240),
    YELLOW(-205),
    T_YELLOW(-1996488909),
    CYAN(-13404297),
    T_CYAN(-2009893001),
    PURPLE(-6736897),
    T_PURPLE(-2003225601),
    PINK(-52225),
    T_PINK(-1996540929),
    BLUE(-12037377),
    T_BLUE(-2008526081),
    ORANGE(-30720),
    T_ORANGE(-1996519424),
    BROWN(-5605564),
    T_BROWN(-2002094268),
    LIME(-8934844),
    T_LIME(-2005423548),
    MAGENTA(-5618518),
    T_MAGENTA(-2002107222),
    LIGHT_BLUE(-12276993),
    T_LIGHT_BLUE(-2008765697);

    public final int color;

    private ColorPattern(int color) {
        this.color = color;
    }

    public ColorRectTexture rectTexture() {
        return new ColorRectTexture(this.color);
    }

    public ColorBorderTexture borderTexture(int border) {
        return new ColorBorderTexture(border, this.color);
    }

    public static int generateRainbowColor(long tick) {
        float hue = (float)(tick % 70L) / 70.0f;
        int rgb = ColorUtils.HSBtoRGB(hue, 1.0f, 1.0f);
        return 0xFF000000 | rgb & 0xFFFFFF;
    }

    public static int generateRainbowColor() {
        float hue = (float)(System.currentTimeMillis() % 3600L) / 3600.0f;
        int rgb = ColorUtils.HSBtoRGB(hue, 1.0f, 1.0f);
        return 0xFF000000 | rgb & 0xFFFFFF;
    }

    public static ColorRectTexture rainbowRectTexture() {
        return new ColorRectTexture(ColorPattern.generateRainbowColor());
    }

    public static ColorBorderTexture rainbowRectTexture(int border) {
        return new ColorBorderTexture(border, ColorPattern.generateRainbowColor());
    }
}

