/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.compass.component.animation;

import com.lowdragmc.lowdraglib.client.scene.ISceneBlockRenderHook;
import com.lowdragmc.lowdraglib.client.scene.ISceneEntityRenderHook;
import com.lowdragmc.lowdraglib.client.scene.WorldSceneRenderer;
import com.lowdragmc.lowdraglib.client.utils.RenderUtils;
import com.lowdragmc.lowdraglib.gui.animation.Transform;
import com.lowdragmc.lowdraglib.gui.compass.CompassManager;
import com.lowdragmc.lowdraglib.gui.compass.component.CompassComponent;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.AnimationFrame;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.BlockAnima;
import com.lowdragmc.lowdraglib.gui.compass.component.animation.TooltipBGTexture;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.BlockPosFace;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.lowdragmc.lowdraglib.utils.EntityInfo;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.lowdragmc.lowdraglib.utils.XmlUtils;
import com.lowdragmc.lowdraglib.utils.interpolate.Eases;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class CompassScene
extends WidgetGroup
implements ISceneBlockRenderHook,
ISceneEntityRenderHook {
    protected final SceneWidget sceneWidget;
    protected final WidgetGroup headerGroup;
    protected final int minX;
    protected final int minY = 0;
    protected final int minZ;
    protected final int maxX;
    protected final int maxY = 0;
    protected final int maxZ;
    protected final List<AnimationFrame> frames;
    protected final boolean useScene;
    protected final boolean tickScene;
    protected TrackedDummyWorld world;
    private final Map<BlockPos, Tuple<BlockAnima, Integer>> addedBlocks = new HashMap<BlockPos, Tuple<BlockAnima, Integer>>();
    private final Map<BlockPos, Tuple<BlockAnima, Integer>> removedBlocks = new HashMap<BlockPos, Tuple<BlockAnima, Integer>>();
    private final Map<BlockPosFace, Integer> highlightBlocks = new HashMap<BlockPosFace, Integer>();
    private final Map<Vec3, MutableTriple<Tuple<XmlUtils.SizedIngredient, List<Component>>, Vec2, Integer>> tooltipBlocks = new HashMap<Vec3, MutableTriple<Tuple<XmlUtils.SizedIngredient, List<Component>>, Vec2, Integer>>();
    private final Map<Vec3, Vec2> tooltipPos = new HashMap<Vec3, Vec2>();
    private int currentFrame = -1;
    private int frameTick = 0;
    private boolean isPause;

    public CompassScene(int width, CompassComponent component) {
        super(0, 0, width, component.getHeight());
        this.frames = component.getFrames();
        this.useScene = component.isUseScene();
        this.tickScene = component.isTickScene();
        this.minX = -component.getRange();
        this.minZ = -component.getRange();
        this.maxX = component.getRange();
        this.maxZ = component.getRange();
        int height = component.getHeight();
        int headerHeight = 80;
        int sceneHeight = height - headerHeight;
        if (this.useScene) {
            int sw = sceneHeight * 4;
            this.world = new TrackedDummyWorld();
            this.sceneWidget = new SceneWidget((width - sw) / 2, headerHeight, sw, sceneHeight, this.world);
            this.sceneWidget.setHoverTips(true).useOrtho(component.isOrtho()).setOrthoRange(0.5f).setScalable(component.isScalable()).setDraggable(false).setRenderFacing(false).setRenderSelect(false);
            this.sceneWidget.getRenderer().setFov(30.0f);
            this.sceneWidget.setRenderedCore(List.of(BlockPos.f_121853_), this);
            this.sceneWidget.getRenderer().setSceneEntityRenderHook(this);
            if (component.getZoom() > 0.0f) {
                this.sceneWidget.setZoom(component.getZoom());
            } else {
                this.sceneWidget.setZoom(9.0f * Mth.m_14116_((float)(this.maxX - this.minX)));
            }
            this.sceneWidget.setBeforeWorldRender(this::renderBeforeWorld);
            this.sceneWidget.setAfterWorldRender(this::renderAfterWorld);
            this.sceneWidget.setCameraYawAndPitch(component.getYaw(), this.sceneWidget.getRotationPitch());
            this.addWidget(this.sceneWidget);
        } else {
            this.sceneWidget = null;
        }
        this.headerGroup = new WidgetGroup(0, 0, width, this.useScene ? headerHeight : height - 25);
        this.addWidget(this.headerGroup);
        this.addWidget(new ButtonWidget((width - 12) / 2 + 20, height - 20, 12, 12, Icons.REPLAY, this::replay).setHoverTexture(Icons.REPLAY.copy().setColor(ColorPattern.GREEN.color)));
        this.addWidget(new ButtonWidget((width - 12) / 2, height - 20, 12, 12, Icons.ROTATION, this::rotation).setHoverTexture(Icons.ROTATION.copy().setColor(ColorPattern.GREEN.color)));
        this.addWidget(new ButtonWidget((width - 12) / 2 + 40, height - 20, 12, 12, Icons.borderText(0, "+", -1), cd -> this.zoom(-1)).setHoverTexture(Icons.borderText(0, "+", ColorPattern.GREEN.color)));
        this.addWidget(new ButtonWidget((width - 12) / 2 - 40, height - 20, 12, 12, Icons.borderText(0, "-", -1), cd -> this.zoom(1)).setHoverTexture(Icons.borderText(0, "-", ColorPattern.GREEN.color)));
        this.addWidget(new SwitchWidget((width - 12) / 2 - 20, height - 20, 12, 12, this::playPause).setSupplier(() -> this.isPause).setTexture(Icons.PLAY_PAUSE, Icons.PLAY_PAUSE.copy().setColor(ColorPattern.GREEN.color)).setClientSideWidget());
        if (!this.frames.isEmpty()) {
            int progressWidth = (width - 2) / this.frames.size();
            for (int i = 0; i < this.frames.size(); ++i) {
                AnimationFrame frame = this.frames.get(i);
                int frameIndex = i;
                this.addWidget(new ProgressWidget(() -> {
                    if (this.currentFrame < 0) {
                        return 0.0;
                    }
                    if (frameIndex < this.currentFrame) {
                        return 1.0;
                    }
                    if (this.frameTick > 0 && frameIndex == this.currentFrame) {
                        int duration = frame.getDuration();
                        return ((float)this.frameTick + (this.isPause ? 0.0f : Minecraft.m_91087_().m_91297_())) / (float)Math.max(duration, 1);
                    }
                    return 0.0;
                }, progressWidth * i + 1 + 1, height - 6 + 1, progressWidth - 4, 4, new ProgressTexture(IGuiTexture.EMPTY, ColorPattern.WHITE.rectTexture())));
                this.addWidget(new ButtonWidget(progressWidth * i + 1, height - 6, progressWidth - 2, 6, ColorPattern.WHITE.borderTexture(1), cd -> this.jumpFrame(frame)).setHoverTooltips(frame.tooltips()).setHoverTexture(ColorPattern.GREEN.borderTexture(1)));
            }
        }
    }

    private void zoom(int value) {
        if (!this.useScene) {
            return;
        }
        float zoom = (float)Mth.m_14008_((double)(this.sceneWidget.getZoom() + (float)value), (double)0.1, (double)999.0);
        this.sceneWidget.setZoom(zoom);
    }

    private void renderBeforeWorld(SceneWidget sceneWidget) {
        GuiGraphics graphics = new GuiGraphics(Minecraft.m_91087_(), MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_()));
        graphics.m_280168_().m_85836_();
        RenderUtils.moveToFace(graphics.m_280168_(), (float)(this.minX + this.maxX) / 2.0f, 0.0, (float)(this.minZ + this.maxZ) / 2.0f, Direction.DOWN);
        RenderUtils.rotateToFace(graphics.m_280168_(), Direction.UP, null);
        int w = this.maxX - this.minX + 3;
        int h = this.maxZ - this.minZ + 3;
        new ResourceTexture("ldlib:textures/gui/darkened_slot.png").draw(graphics, 0, 0, (float)w / -2.0f, (float)h / -2.0f, w, h);
        graphics.m_280168_().m_85849_();
    }

    private void renderAfterWorld(SceneWidget sceneWidget) {
        PoseStack matrixStack = new PoseStack();
        float tick = Math.abs(Minecraft.m_91087_().m_91297_() + (float)(this.gui.getTickCount() % 40L) - 20.0f) / 20.0f;
        for (Map.Entry<BlockPosFace, Integer> entry : this.highlightBlocks.entrySet()) {
            if (entry.getValue() <= 0) continue;
            if (entry.getKey().facing == null) {
                RenderUtils.renderBlockOverLay(matrixStack, entry.getKey().pos, 0.6f * tick, 0.0f, 0.0f, 1.01f);
                continue;
            }
            sceneWidget.drawFacingBorder(matrixStack, entry.getKey(), ColorUtils.color(1.0f * tick, 0.0f, 0.6f, 0.0f));
        }
        Window window = Minecraft.m_91087_().m_91268_();
        for (Vec3 pos : this.tooltipBlocks.keySet()) {
            Vector3f result = sceneWidget.getRenderer().project(new Vector3f((float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_));
            float x = result.x() * (float)window.m_85445_() / (float)window.m_85441_();
            float y = ((float)window.m_85442_() - result.y()) * (float)window.m_85446_() / (float)window.m_85442_();
            this.tooltipPos.put(pos, new Vec2(x, y));
        }
    }

    @Override
    public void drawInForeground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        Position position = this.getPosition();
        Size size = this.getSize();
        for (Map.Entry<Vec3, MutableTriple<Tuple<XmlUtils.SizedIngredient, List<Component>>, Vec2, Integer>> entry : this.tooltipBlocks.entrySet()) {
            int maxWidth;
            Vec2 screenPos = this.tooltipPos.get(entry.getKey());
            if (screenPos == null) continue;
            Tuple tuple = (Tuple)entry.getValue().getLeft();
            XmlUtils.SizedIngredient ingredient = (XmlUtils.SizedIngredient)tuple.m_14418_();
            ItemStack[] items = (ItemStack[])Arrays.stream(ingredient.ingredient().m_43908_()).map(i -> {
                ItemStack copied = i.m_41777_();
                copied.m_41764_(ingredient.count());
                return copied;
            }).toArray(ItemStack[]::new);
            List tooltips = (List)tuple.m_14419_();
            mouseX = (int)((float)position.x + (float)size.width * ((Vec2)entry.getValue().getMiddle()).f_82470_);
            mouseY = (int)((float)position.y + (float)size.height * ((Vec2)entry.getValue().getMiddle()).f_82471_);
            DrawerHelper.drawLines(graphics, List.of(screenPos, new Vec2((float)mouseX, (float)mouseY)), -1, -1, 0.75f);
            ComponentPanelWidget componentPanelWidget = new ComponentPanelWidget(0, 0, tooltips).clickHandler(CompassManager::onComponentClick);
            componentPanelWidget.setBackground(TooltipBGTexture.INSTANCE);
            for (maxWidth = 200; maxWidth < size.width && (componentPanelWidget.getSize().height == 0 || (float)(componentPanelWidget.getSize().height + mouseY) < (float)size.height * (1.0f - ((Vec2)entry.getValue().getMiddle()).f_82471_)); maxWidth += 50) {
                componentPanelWidget.setMaxWidthLimit(maxWidth);
            }
            componentPanelWidget.addSelfPosition(mouseX, mouseY);
            maxWidth = componentPanelWidget.getSize().width;
            int maxHeight = componentPanelWidget.getSize().height;
            int rightSpace = this.getGui().getScreenWidth() - mouseX;
            int bottomSpace = this.getGui().getScreenHeight() - mouseY;
            if (rightSpace < maxWidth) {
                componentPanelWidget.addSelfPosition(rightSpace - maxWidth, 0);
            }
            if (bottomSpace < maxHeight) {
                componentPanelWidget.addSelfPosition(0, bottomSpace - maxHeight);
            }
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
            componentPanelWidget.drawInBackground(graphics, mouseX, mouseY, partialTicks);
            if (items.length > 0) {
                new ItemStackTexture(items).draw(graphics, mouseX, mouseY, componentPanelWidget.getPosition().x + 2, componentPanelWidget.getPosition().y - 20, 16, 16);
            }
            graphics.m_280168_().m_85849_();
        }
    }

    private void playPause(ClickData clickData, boolean isPressed) {
        this.isPause = isPressed;
    }

    private void rotation(ClickData clickData) {
        if (!this.useScene) {
            return;
        }
        float current = this.sceneWidget.getRotationPitch();
        this.sceneWidget.setCameraYawAndPitchAnima(this.sceneWidget.getRotationYaw(), current + 90.0f, 20);
    }

    private void resetScene() {
        this.world.clear();
        this.sceneWidget.setCameraYawAndPitch(this.sceneWidget.getRotationYaw(), -135.0f);
        this.sceneWidget.getCore().clear();
        this.sceneWidget.getCore().add(BlockPos.f_121853_);
        this.headerGroup.clearAllWidgets();
        this.addedBlocks.clear();
        this.removedBlocks.clear();
        this.highlightBlocks.clear();
        this.tooltipBlocks.clear();
        this.currentFrame = -1;
    }

    private void jumpFrame(AnimationFrame frame) {
        this.resetScene();
        this.currentFrame = 0;
        for (AnimationFrame animationFrame : this.frames) {
            if (animationFrame != frame) {
                animationFrame.performFrameResult(this);
                ++this.currentFrame;
                continue;
            }
            this.frameTick = 0;
            break;
        }
    }

    private void replay(ClickData clickData) {
        this.resetScene();
        this.isPause = false;
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (this.frames.isEmpty()) {
            return;
        }
        if (!this.isPause) {
            this.addedBlocks.forEach((p, v) -> v.m_145025_((Object)((Integer)v.m_14419_() - 1)));
            this.removedBlocks.forEach((p, v) -> v.m_145025_((Object)((Integer)v.m_14419_() - 1)));
            this.highlightBlocks.replaceAll((p, v) -> v - 1);
            this.tooltipBlocks.forEach((p, v) -> v.setRight((Object)((Integer)v.getRight() - 1)));
            this.addedBlocks.entrySet().removeIf(e -> (Integer)((Tuple)e.getValue()).m_14419_() <= 0);
            this.highlightBlocks.entrySet().removeIf(e -> (Integer)e.getValue() <= 0);
            this.tooltipBlocks.entrySet().removeIf(e -> (Integer)((MutableTriple)e.getValue()).getRight() <= 0);
            Iterator<Map.Entry<BlockPos, Tuple<BlockAnima, Integer>>> iterator = this.removedBlocks.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<BlockPos, Tuple<BlockAnima, Integer>> entry = iterator.next();
                if ((Integer)entry.getValue().m_14419_() > 0) continue;
                this.world.removeBlock(entry.getKey());
                this.sceneWidget.getCore().remove(entry.getKey());
                iterator.remove();
            }
            if (this.currentFrame < 0) {
                this.nextFrame();
            }
            if (this.currentFrame >= 0 && this.currentFrame < this.frames.size() && this.frames.get(this.currentFrame).onFrameTick(this, this.frameTick++)) {
                this.nextFrame();
            }
            if (this.tickScene && this.useScene) {
                this.world.tickWorld();
            }
        }
    }

    protected void nextFrame() {
        if (this.currentFrame < 0) {
            this.currentFrame = 0;
        } else {
            ++this.currentFrame;
            if (this.currentFrame >= this.frames.size()) {
                this.currentFrame = -1;
                this.frameTick = 0;
                this.isPause = true;
                return;
            }
        }
        this.frameTick = -this.frames.get(this.currentFrame).delay();
    }

    @Override
    public void applyEntity(Level world, Entity entity, PoseStack poseStack, float partialTicks) {
        ISceneEntityRenderHook.super.applyEntity(world, entity, poseStack, partialTicks);
    }

    @Override
    public void applyBESR(Level world, BlockPos pos, BlockEntity blockEntity, PoseStack poseStack, float partialTicks) {
        if (this.isPause) {
            partialTicks = 0.0f;
        }
        if (this.removedBlocks.containsKey(pos)) {
            Tuple<BlockAnima, Integer> tuple = this.removedBlocks.get(pos);
            BlockAnima anima = (BlockAnima)tuple.m_14418_();
            float tick = 1.0f - ((float)((Integer)tuple.m_14419_()).intValue() - partialTicks) / (float)anima.duration();
            if (tick > 0.0f) {
                poseStack.m_85837_((double)tick * anima.offset().f_82479_, (double)tick * anima.offset().f_82480_, (double)tick * anima.offset().f_82481_);
            }
        } else if (this.addedBlocks.containsKey(pos)) {
            Tuple<BlockAnima, Integer> tuple = this.addedBlocks.get(pos);
            BlockAnima anima = (BlockAnima)tuple.m_14418_();
            float tick = ((float)((Integer)tuple.m_14419_()).intValue() - partialTicks) / (float)anima.duration();
            if (tick > 0.0f) {
                tick = Eases.EaseQuadIn.getInterpolation(tick);
                poseStack.m_85837_((double)tick * anima.offset().f_82479_, (double)tick * anima.offset().f_82480_, (double)tick * anima.offset().f_82481_);
            }
        }
    }

    @Override
    public void applyVertexConsumerWrapper(Level world, BlockPos pos, BlockState state, WorldSceneRenderer.VertexConsumerWrapper wrapperBuffer, RenderType layer, float partialTicks) {
        if (this.isPause) {
            partialTicks = 0.0f;
        }
        if (this.removedBlocks.containsKey(pos)) {
            Tuple<BlockAnima, Integer> tuple = this.removedBlocks.get(pos);
            BlockAnima anima = (BlockAnima)tuple.m_14418_();
            float tick = 1.0f - ((float)((Integer)tuple.m_14419_()).intValue() - partialTicks) / (float)anima.duration();
            if (tick > 0.0f) {
                wrapperBuffer.addOffset((double)tick * anima.offset().f_82479_, (double)tick * anima.offset().f_82480_, (double)tick * anima.offset().f_82481_);
            }
        } else if (this.addedBlocks.containsKey(pos)) {
            Tuple<BlockAnima, Integer> tuple = this.addedBlocks.get(pos);
            BlockAnima anima = (BlockAnima)tuple.m_14418_();
            float tick = ((float)((Integer)tuple.m_14419_()).intValue() - partialTicks) / (float)anima.duration();
            if (tick > 0.0f) {
                tick = Eases.EaseQuadIn.getInterpolation(tick);
                wrapperBuffer.addOffset((double)tick * anima.offset().f_82479_, (double)tick * anima.offset().f_82480_, (double)tick * anima.offset().f_82481_);
            }
        }
    }

    public void addBlock(BlockPos pos, BlockInfo blockInfo, @Nullable BlockAnima anima) {
        if (!this.useScene) {
            return;
        }
        if (blockInfo.getBlockState().m_60734_() == Blocks.f_50016_) {
            this.removeBlock(pos, null);
            return;
        }
        this.world.addBlock(pos, blockInfo);
        this.sceneWidget.getCore().add(pos);
        if (anima != null) {
            this.addedBlocks.put(pos, (Tuple<BlockAnima, Integer>)new Tuple((Object)anima, (Object)anima.duration()));
        }
    }

    public void removeBlock(BlockPos pos, @Nullable BlockAnima anima) {
        if (!this.useScene) {
            return;
        }
        if (anima != null) {
            this.removedBlocks.put(pos, (Tuple<BlockAnima, Integer>)new Tuple((Object)anima, (Object)anima.duration()));
        } else {
            this.world.removeBlock(pos);
            this.sceneWidget.getCore().remove(pos);
        }
    }

    public void highlightBlock(BlockPosFace key, int duration) {
        if (!this.useScene) {
            return;
        }
        this.highlightBlocks.put(key, duration);
    }

    public void addEntity(EntityInfo entityInfo, @Nullable Vec3 pos, boolean update) {
        Entity entity = null;
        if (update) {
            entity = this.world.entities.get(entityInfo.getId());
        }
        Entity entity2 = entity = entity == null && entityInfo.getEntityType() != null ? entityInfo.getEntityType().m_20615_((Level)this.world) : entity;
        if (entity == null && entityInfo.getEntityType() == EntityType.f_20532_) {
            entity = new RemotePlayer(this.world.getAsClientWorld().get(), Minecraft.m_91087_().f_91074_.m_36316_());
        }
        if (entity != null) {
            entity.m_20234_(entityInfo.getId());
            if (pos != null) {
                entity.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            }
            if (entityInfo.getTag() != null) {
                entity.m_20258_(entity.m_20240_(new CompoundTag()).m_6426_().m_128391_(entityInfo.getTag()));
            }
            this.world.m_7967_(entity);
        }
    }

    public void removeEntity(EntityInfo entityInfo, boolean force) {
        if (force) {
            this.world.entities.remove(entityInfo.getId());
        } else {
            Optional.ofNullable(this.world.entities.get(entityInfo.getId())).ifPresent(Entity::m_146870_);
        }
    }

    public void addTooltip(Vec3 pos, Tuple<XmlUtils.SizedIngredient, List<Component>> tuple, Vec2 middle, Integer time) {
        this.tooltipBlocks.put(pos, (MutableTriple<Tuple<XmlUtils.SizedIngredient, List<Component>>, Vec2, Integer>)MutableTriple.of(tuple, (Object)middle, (Object)time));
    }

    public void rotate(float rotation, boolean anima) {
        if (!this.useScene) {
            return;
        }
        float current = this.sceneWidget.getRotationPitch();
        current += (rotation - 135.0f - current) % 360.0f;
        if (anima) {
            this.sceneWidget.setCameraYawAndPitchAnima(this.sceneWidget.getRotationYaw(), current, 20);
        } else {
            this.sceneWidget.setCameraYawAndPitch(this.sceneWidget.getRotationYaw(), current);
        }
    }

    public void addInformation(Widget widget, boolean anima) {
        if (anima) {
            for (Widget child : this.headerGroup.widgets) {
                this.headerGroup.removeWidgetAnima(child, new Transform().duration(500L).offset(-child.getSelfPosition().x - child.getSize().width, 0));
            }
        } else {
            this.headerGroup.clearAllWidgets();
        }
        Size size = this.headerGroup.getSize();
        widget.setSelfPosition(new Position((size.width - widget.getSize().width) / 2, (size.height - widget.getSize().height) / 2));
        if (anima) {
            this.headerGroup.addWidgetAnima(widget, new Transform().ease(Eases.EaseQuadOut).duration(500L).offset(size.width - widget.getSelfPosition().x, 0));
        } else {
            this.headerGroup.addWidget(widget);
        }
    }

    public SceneWidget getSceneWidget() {
        return this.sceneWidget;
    }

    public WidgetGroup getHeaderGroup() {
        return this.headerGroup;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        Objects.requireNonNull(this);
        return 0;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        Objects.requireNonNull(this);
        return 0;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public List<AnimationFrame> getFrames() {
        return this.frames;
    }
}

