/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.compass.component;

import com.lowdragmc.lowdraglib.gui.compass.ILayoutComponent;
import com.lowdragmc.lowdraglib.gui.compass.LayoutPageWidget;
import com.lowdragmc.lowdraglib.gui.compass.component.AbstractComponent;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.utils.CycleItemStackHandler;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import org.w3c.dom.Element;

public class RecipeComponent
extends AbstractComponent {
    public static final ResourceTexture PROGRESS_BAR_ARROW = new ResourceTexture("ldlib:textures/gui/progress_bar_arrow.png");
    private static final List<RecipeViewCreator> RECIPE_VIEW_CREATORS = new ArrayList<RecipeViewCreator>();
    @Nullable
    protected Recipe<?> recipe;

    public static void registerRecipeViewCreator(RecipeViewCreator recipeViewCreator) {
        RECIPE_VIEW_CREATORS.add(recipeViewCreator);
    }

    @Override
    public ILayoutComponent fromXml(Element element) {
        super.fromXml(element);
        if (element.hasAttribute("id")) {
            ResourceLocation recipeID = new ResourceLocation(element.getAttribute("id"));
            for (Recipe recipe : Minecraft.m_91087_().m_91403_().m_105141_().m_44051_()) {
                if (!recipe.m_6423_().equals((Object)recipeID)) continue;
                this.recipe = recipe;
                return this;
            }
        }
        return this;
    }

    @Override
    protected LayoutPageWidget addWidgets(LayoutPageWidget currentPage) {
        if (this.recipe == null) {
            return currentPage;
        }
        Int2ObjectArrayMap inputs = new Int2ObjectArrayMap();
        ItemStack output = this.recipe.m_8043_((RegistryAccess)RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_));
        NonNullList ingredients = this.recipe.m_7527_();
        Recipe<?> recipe = this.recipe;
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            int w = shapedRecipe.m_44220_();
            int h = shapedRecipe.m_44221_();
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < h; ++j) {
                    inputs.put(i + j * w, (Object)((Ingredient)ingredients.get(i + j * w)));
                }
            }
        } else {
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.put(i, (Object)((Ingredient)ingredients.get(i)));
            }
        }
        Widget recipeGroup = null;
        ItemStack workstation = ItemStack.f_41583_;
        for (RecipeViewCreator creator : RECIPE_VIEW_CREATORS) {
            if (!creator.test(this.recipe)) continue;
            recipeGroup = creator.getViewWidget(this.recipe);
            workstation = creator.getWorkstation(this.recipe);
            break;
        }
        if (recipeGroup == null) {
            if (this.recipe instanceof CraftingRecipe) {
                recipeGroup = this.createCraftingRecipeWidget((Int2ObjectMap<Ingredient>)inputs, output);
                workstation = new ItemStack((ItemLike)Items.f_41960_);
            } else if (this.recipe instanceof AbstractCookingRecipe) {
                recipeGroup = this.createSmeltingRecipeWidget((Int2ObjectMap<Ingredient>)inputs, output);
                workstation = new ItemStack((ItemLike)Items.f_41962_);
            } else {
                recipeGroup = this.createCraftingRecipeWidget((Int2ObjectMap<Ingredient>)inputs, output);
            }
        }
        ((WidgetGroup)recipeGroup).addWidget(new ImageWidget(-40, recipeGroup.getSize().height / 2 - 15, 30, 30, new ItemStackTexture(workstation)));
        return currentPage.addStreamWidget(this.wrapper(recipeGroup));
    }

    protected WidgetGroup createSmeltingRecipeWidget(Int2ObjectMap<Ingredient> input, ItemStack output) {
        WidgetGroup widgetGroup = new WidgetGroup(0, 0, 150, 30);
        widgetGroup.setBackground(ResourceBorderTexture.BORDERED_BACKGROUND);
        CycleItemStackHandler itemStackHandler = new CycleItemStackHandler(List.of(Arrays.stream(((Ingredient)input.getOrDefault(0, (Object)Ingredient.f_43901_)).m_43908_()).toList()));
        widgetGroup.addWidget(new SlotWidget(itemStackHandler, 0, 20, 6, false, false));
        ItemStackTransfer handler = new ItemStackTransfer();
        handler.setStackInSlot(0, output);
        widgetGroup.addWidget(new ProgressWidget(ProgressWidget.JEIProgress, 65, 5, 20, 20, new ProgressTexture()));
        widgetGroup.addWidget(new SlotWidget(handler, 0, 120, 6, false, false));
        return widgetGroup;
    }

    protected WidgetGroup createCraftingRecipeWidget(Int2ObjectMap<Ingredient> input, ItemStack output) {
        WidgetGroup widgetGroup = new WidgetGroup(0, 0, 150, 66);
        widgetGroup.setBackground(ResourceBorderTexture.BORDERED_BACKGROUND);
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                CycleItemStackHandler itemStackHandler = new CycleItemStackHandler(List.of(Arrays.stream(((Ingredient)input.getOrDefault(x + y * 3, (Object)Ingredient.f_43901_)).m_43908_()).toList()));
                widgetGroup.addWidget(new SlotWidget(itemStackHandler, 0, x * 18 + 20, y * 18 + 6, false, false));
            }
        }
        ItemStackTransfer handler = new ItemStackTransfer();
        handler.setStackInSlot(0, output);
        widgetGroup.addWidget(new ProgressWidget(ProgressWidget.JEIProgress, 87, 23, 20, 20, PROGRESS_BAR_ARROW));
        widgetGroup.addWidget(new SlotWidget(handler, 0, 120, 24, false, false));
        return widgetGroup;
    }

    public static interface RecipeViewCreator
    extends Predicate<Recipe<?>> {
        public ItemStack getWorkstation(Recipe<?> var1);

        public WidgetGroup getViewWidget(Recipe<?> var1);
    }
}

