/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.scene.forge;

import com.lowdragmc.lowdraglib.utils.DummyWorld;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelDataManager;

public class WorldSceneRendererImpl {
    public static ModelData getModelData(BakedModel model, BlockState state, BlockPos pos, BlockAndTintGetter level) {
        BlockEntity be;
        ModelDataManager manager = level.getModelDataManager();
        ModelData modelData = null;
        if (manager == null && level instanceof DummyWorld) {
            DummyWorld dummyLevel = (DummyWorld)level;
            manager = dummyLevel.getLevel().getModelDataManager();
        }
        if (manager != null) {
            modelData = manager.getAt(pos);
        }
        if (modelData == null && (be = level.getExistingBlockEntity(pos)) != null) {
            modelData = be.getModelData();
        }
        return model.getModelData(level, pos, state, modelData != null ? modelData : ModelData.EMPTY);
    }

    public static boolean canRenderInLayer(BlockRenderDispatcher blockRenderDispatcher, BlockState state, BlockPos pos, BlockAndTintGetter level, RenderType renderType, RandomSource random) {
        BakedModel blockModel = blockRenderDispatcher.m_110910_(state);
        ModelData modelData = WorldSceneRendererImpl.getModelData(blockModel, state, pos, level);
        return blockModel.getRenderTypes(state, random, modelData).contains(renderType);
    }

    public static void renderBlocksForge(BlockRenderDispatcher blockRenderDispatcher, BlockState state, BlockPos pos, BlockAndTintGetter level, @Nonnull PoseStack poseStack, VertexConsumer consumer, RandomSource random, RenderType renderType) {
        if (state.m_60799_() != RenderShape.MODEL) {
            return;
        }
        BakedModel blockModel = blockRenderDispatcher.m_110910_(state);
        ModelData modelData = WorldSceneRendererImpl.getModelData(blockModel, state, pos, level);
        blockRenderDispatcher.m_110937_().tesselateBlock(level, blockModel, state, pos, poseStack, consumer, true, random, state.m_60726_(pos), OverlayTexture.f_118083_, modelData, renderType);
    }
}

