/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IRenderer {
    public static final Set<IRenderer> EVENT_REGISTERS = new HashSet<IRenderer>();
    public static final IRenderer EMPTY = new IRenderer(){};

    @OnlyIn(value=Dist.CLIENT)
    default public void renderItem(ItemStack stack, ItemDisplayContext transformType, boolean leftHand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel model) {
    }

    @OnlyIn(value=Dist.CLIENT)
    default public List<BakedQuad> renderModel(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos, @Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return Collections.emptyList();
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void onPrepareTextureAtlas(ResourceLocation atlasName, Consumer<ResourceLocation> register) {
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void onAdditionalModel(Consumer<ResourceLocation> registry) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyIn(value=Dist.CLIENT)
    default public void registerEvent() {
        Set<IRenderer> set = EVENT_REGISTERS;
        synchronized (set) {
            EVENT_REGISTERS.add(this);
        }
    }

    default public boolean isRaw() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean hasTESR(BlockEntity blockEntity) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean isGlobalRenderer(BlockEntity blockEntity) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public int getViewDistance() {
        return 64;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean shouldRender(BlockEntity blockEntity, Vec3 cameraPos) {
        return Vec3.m_82512_((Vec3i)blockEntity.m_58899_()).m_82509_((Position)cameraPos, (double)this.getViewDistance());
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void render(BlockEntity blockEntity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    default public TextureAtlasSprite getParticleTexture() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(MissingTextureAtlasSprite.m_118071_());
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean useAO() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean useAO(BlockState state) {
        return this.useAO();
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean useBlockLight(ItemStack stack) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean reBakeCustomQuads() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public float reBakeCustomQuadsOffset() {
        return 0.002f;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean isGui3d() {
        return true;
    }
}

