/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.ars_creo.common.display;

import com.hollingsworth.arsnouveau.common.block.tile.BasicSpellTurretTile;
import com.simibubi.create.api.behaviour.display.DisplaySource;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;

public class TurretDisplaySource
extends DisplaySource {
    public static final List<MutableComponent> notEnoughSpaceSingle = List.of(Component.m_237115_((String)"ars_creo.display_source.turret.not_enough_space").m_7220_((Component)Component.m_237115_((String)"ars_creo.display_source.turret.for_turret_status")));

    public List<MutableComponent> provideText(DisplayLinkContext context, DisplayTargetStats stats) {
        if (stats.maxRows() < 2) {
            return notEnoughSpaceSingle;
        }
        boolean isBook = context.getTargetBlockEntity() instanceof LecternBlockEntity;
        if (isBook) {
            Stream<MutableComponent> componentList = this.getComponents(context, false).map(components -> {
                Optional reduce = components.stream().reduce(MutableComponent::m_7220_);
                return reduce.orElse(EMPTY_LINE);
            });
            return List.of(componentList.reduce((comp1, comp2) -> comp1.m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)comp2)).orElse(EMPTY_LINE));
        }
        return this.getComponents(context, false).map(components -> {
            Optional reduce = components.stream().reduce(MutableComponent::m_7220_);
            return reduce.orElse(EMPTY_LINE);
        }).toList();
    }

    private Stream<List<MutableComponent>> getComponents(DisplayLinkContext context, boolean forFlapDisplay) {
        BlockEntity sourceBE = context.getSourceBlockEntity();
        if (!(sourceBE instanceof BasicSpellTurretTile)) {
            return Stream.empty();
        }
        BasicSpellTurretTile turretTile = (BasicSpellTurretTile)sourceBE;
        if (turretTile.getSpellCaster() == null || turretTile.getSpellCaster().getSpell().isEmpty()) {
            return Stream.of(List.of(Component.m_237115_((String)"ars_creo.display_source.turret.no_spell")));
        }
        return Stream.of(List.of(Component.m_237110_((String)"ars_creo.display_source.turret.spell_name", (Object[])new Object[]{turretTile.getSpellCaster().getSpell().name})), List.of(Component.m_237110_((String)"ars_creo.display_source.turret.spell", (Object[])new Object[]{turretTile.getSpellCaster().getSpell().getDisplayString()})));
    }
}

