/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.DataStructures.EntityData;
import com.darkere.crashutils.DataStructures.LoadedChunkData;
import com.darkere.crashutils.DataStructures.PlayerData;
import com.darkere.crashutils.DataStructures.TileEntityData;
import com.darkere.crashutils.Network.DataRequestType;
import com.darkere.crashutils.Network.EntityDataMessage;
import com.darkere.crashutils.Network.LoadedChunkDataStateMessage;
import com.darkere.crashutils.Network.LoadedChunkDataTicketsMessage;
import com.darkere.crashutils.Network.Network;
import com.darkere.crashutils.Network.NetworkTools;
import com.darkere.crashutils.Network.PlayerDataMessage;
import com.darkere.crashutils.Network.TileEntityDataMessage;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class UpdateDataRequestMessage {
    private DataRequestType type;
    private ResourceKey<Level> worldKey;

    public UpdateDataRequestMessage(DataRequestType type, ResourceKey<Level> worldKey) {
        this.type = type;
        this.worldKey = worldKey;
    }

    public static void encode(UpdateDataRequestMessage data, FriendlyByteBuf buf) {
        buf.writeInt(data.type.ordinal());
        NetworkTools.writeWorldKey(data.worldKey, buf);
    }

    public static UpdateDataRequestMessage decode(FriendlyByteBuf buf) {
        return new UpdateDataRequestMessage(DataRequestType.values()[buf.readInt()], NetworkTools.readWorldKey(buf));
    }

    public static void handle(UpdateDataRequestMessage data, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getSender() == null) {
                return;
            }
            if (!((NetworkEvent.Context)ctx.get()).getSender().m_20310_(2)) {
                return;
            }
            MinecraftServer server = ((NetworkEvent.Context)ctx.get()).getSender().m_20194_();
            if (server == null) {
                return;
            }
            ServerLevel world = server.m_129880_(data.worldKey);
            List<ServerLevel> worlds = Collections.singletonList(world);
            switch (data.type) {
                case LOADEDCHUNKDATA: {
                    LoadedChunkData loadedChunkData = new LoadedChunkData(worlds);
                    CrashUtils.runNextTick(arg_0 -> UpdateDataRequestMessage.lambda$handle$0((Supplier)ctx, loadedChunkData, arg_0));
                    CrashUtils.runNextTick(arg_0 -> UpdateDataRequestMessage.lambda$handle$1((Supplier)ctx, loadedChunkData, arg_0));
                    break;
                }
                case ENTITYDATA: {
                    EntityData entityData = new EntityData();
                    entityData.createLists(worlds);
                    Network.sendToPlayer(((NetworkEvent.Context)ctx.get()).getSender(), new EntityDataMessage(entityData));
                    break;
                }
                case TILEENTITYDATA: {
                    TileEntityData tileEntityData = new TileEntityData();
                    tileEntityData.createLists(worlds);
                    Network.sendToPlayer(((NetworkEvent.Context)ctx.get()).getSender(), new TileEntityDataMessage(tileEntityData));
                    break;
                }
                case PLAYERDATA: {
                    PlayerData playerData = new PlayerData();
                    playerData.createLists(worlds);
                    Network.sendToPlayer(((NetworkEvent.Context)ctx.get()).getSender(), new PlayerDataMessage(playerData));
                    break;
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handle$1(Supplier ctx, LoadedChunkData loadedChunkData, ServerLevel lc) {
        Network.sendToPlayer(((NetworkEvent.Context)ctx.get()).getSender(), new LoadedChunkDataTicketsMessage(loadedChunkData.getChunksByTicketName()));
    }

    private static /* synthetic */ void lambda$handle$0(Supplier ctx, LoadedChunkData loadedChunkData, ServerLevel lc) {
        Network.sendToPlayer(((NetworkEvent.Context)ctx.get()).getSender(), new LoadedChunkDataStateMessage(loadedChunkData.getChunksByLocationType()));
    }
}

