/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.world;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.registry.ModEntities;
import alexthw.ars_elemental.registry.ModItems;
import alexthw.ars_elemental.util.SupplierBlockStateProviderAE;
import com.hollingsworth.arsnouveau.common.world.tree.MagicTrunkPlacer;
import com.hollingsworth.arsnouveau.setup.registry.BiomeRegistry;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.SoundRegistry;
import com.hollingsworth.arsnouveau.setup.registry.WorldgenRegistry;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Musics;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModWorldgen {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"ars_elemental");
    public static final String SIMPLE_FLASHING_ID = "simple_flashing";
    public static final String COMMON_FLASHING_ID = "common_flashing";
    public static final String RARE_RANDOM_FLASHING_ID = "random_simple_flashing";
    public static final String COMMON_RANDOM_FLASHING_ID = "random_common_flashing";
    public static final String FINAL_RARE_FLASHING = "flashing_archwood";
    public static final String FINAL_COMMON_FLASHING = "common_flashing_archwood";
    public static final String FINAL_CLUSTER_FLASHING = "cluster_flashing_archwood";
    public static final String FINAL_CLUSTER_CASCADING = "cluster_cascading_archwood";
    public static final String FINAL_CLUSTER_BLAZING = "cluster_blazing_archwood";
    public static final String FINAL_CLUSTER_FLOURISHING = "cluster_flourishing_archwood";
    public static final String FINAL_CLUSTER_VEXING = "cluster_vexing_archwood";
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLASHING_TREE_SAPLING = ModWorldgen.registerConfKey("flashing_tree_sapling");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NATURAL_FLASHING_TREE = ModWorldgen.registerConfKey("natural_flashing_tree");
    public static final ResourceKey<PlacedFeature> SIMPLE_FLASHING_PLACED = ModWorldgen.registerPlacedKey("simple_flashing");
    public static final ResourceKey<PlacedFeature> COMMON_FLASHING_PLACED = ModWorldgen.registerPlacedKey("common_flashing");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RARE_FLASHING_TREES = ModWorldgen.registerConfKey("random_simple_flashing");
    public static final ResourceKey<ConfiguredFeature<?, ?>> COMMON_FLASHING_TREES = ModWorldgen.registerConfKey("random_common_flashing");
    public static final ResourceKey<PlacedFeature> RARE_FLASHING_CONFIGURED = ModWorldgen.registerPlacedKey("flashing_archwood");
    public static final ResourceKey<PlacedFeature> COMMON_FLASHING_CONFIGURED = ModWorldgen.registerPlacedKey("common_flashing_archwood");
    public static final ResourceKey<PlacedFeature> CLUSTER_FLASHING_CONFIGURED = ModWorldgen.registerPlacedKey("cluster_flashing_archwood");
    public static final ResourceKey<PlacedFeature> CLUSTER_BLAZING_CONFIGURED = ModWorldgen.registerPlacedKey("cluster_blazing_archwood");
    public static final ResourceKey<PlacedFeature> CLUSTER_CASCADING_CONFIGURED = ModWorldgen.registerPlacedKey("cluster_cascading_archwood");
    public static final ResourceKey<PlacedFeature> CLUSTER_FLOURISHING_CONFIGURED = ModWorldgen.registerPlacedKey("cluster_flourishing_archwood");
    public static final ResourceKey<PlacedFeature> CLUSTER_VEXING_CONFIGURED = ModWorldgen.registerPlacedKey("cluster_vexing_archwood");

    public static void bootstrapConfiguredFeatures(BootstapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter placed = context.m_255420_(Registries.f_256988_);
        WorldgenRegistry.bootstrapConfiguredFeatures(context);
        context.m_255272_(FLASHING_TREE_SAPLING, (Object)new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new SupplierBlockStateProviderAE("yellow_archwood_log"), (TrunkPlacer)new MagicTrunkPlacer(10, 1, 0, false, "ars_elemental:flashpine_pod"), (BlockStateProvider)new SupplierBlockStateProviderAE("yellow_archwood_leaves"), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)UniformInt.m_146622_((int)0, (int)0), (IntProvider)UniformInt.m_146622_((int)0, (int)0), 0), (FeatureSize)new TwoLayersFeatureSize(2, 0, 2)).m_68244_().m_68251_()));
        context.m_255272_(NATURAL_FLASHING_TREE, (Object)new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new SupplierBlockStateProviderAE("yellow_archwood_log"), (TrunkPlacer)new MagicTrunkPlacer(10, 2, 0, true, "ars_elemental:flashpine_pod"), (BlockStateProvider)new SupplierBlockStateProviderAE("yellow_archwood_leaves"), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)UniformInt.m_146622_((int)0, (int)0), (IntProvider)UniformInt.m_146622_((int)0, (int)0), 0), (FeatureSize)new TwoLayersFeatureSize(2, 0, 2)).m_68251_()));
        context.m_255272_(RARE_FLASHING_TREES, (Object)new ConfiguredFeature(Feature.f_65755_, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placed.m_255043_(SIMPLE_FLASHING_PLACED)}))));
        context.m_255272_(COMMON_FLASHING_TREES, (Object)new ConfiguredFeature(Feature.f_65755_, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placed.m_255043_(COMMON_FLASHING_PLACED)}))));
    }

    public static void bootstrapPlacedFeatures(BootstapContext<PlacedFeature> context) {
        HolderGetter configured = context.m_255420_(Registries.f_256911_);
        WorldgenRegistry.bootstrapPlacedFeatures(context);
        context.m_255272_(SIMPLE_FLASHING_PLACED, (Object)new PlacedFeature((Holder)configured.m_254902_(NATURAL_FLASHING_TREE).get(), List.of(PlacementUtils.m_206493_((Block)((Block)ModItems.FLASHING_SAPLING.get())))));
        context.m_255272_(COMMON_FLASHING_PLACED, (Object)new PlacedFeature((Holder)configured.m_254902_(NATURAL_FLASHING_TREE).get(), List.of(PlacementUtils.m_195364_((int)5, (float)0.01f, (int)1), PlacementUtils.f_195355_, PlacementUtils.m_206493_((Block)((Block)ModItems.FLASHING_SAPLING.get())))));
        context.m_255272_(RARE_FLASHING_CONFIGURED, (Object)new PlacedFeature((Holder)configured.m_254902_(RARE_FLASHING_TREES).get(), VegetationPlacements.m_195479_((PlacementModifier)RarityFilter.m_191900_((int)200))));
        context.m_255272_(COMMON_FLASHING_CONFIGURED, (Object)new PlacedFeature((Holder)configured.m_254902_(COMMON_FLASHING_TREES).get(), VegetationPlacements.m_195481_((PlacementModifier)CountPlacement.m_191628_((int)2), (Block)((Block)ModItems.FLASHING_SAPLING.get()))));
        context.m_255272_(CLUSTER_FLASHING_CONFIGURED, (Object)new PlacedFeature((Holder)configured.m_254902_(COMMON_FLASHING_TREES).get(), VegetationPlacements.m_195481_((PlacementModifier)CountPlacement.m_191628_((int)6), (Block)((Block)ModItems.FLASHING_SAPLING.get()))));
        context.m_255272_(CLUSTER_CASCADING_CONFIGURED, (Object)new PlacedFeature((Holder)configured.m_254902_(WorldgenRegistry.NATURAL_CONFIGURED_CASCADING_TREE).get(), VegetationPlacements.m_195481_((PlacementModifier)CountPlacement.m_191628_((int)6), (Block)((Block)BlockRegistry.CASCADING_SAPLING.get()))));
        context.m_255272_(CLUSTER_BLAZING_CONFIGURED, (Object)new PlacedFeature((Holder)configured.m_254902_(WorldgenRegistry.NATURAL_CONFIGURED_BLAZING_TREE).get(), VegetationPlacements.m_195481_((PlacementModifier)CountPlacement.m_191628_((int)6), (Block)((Block)BlockRegistry.BLAZING_SAPLING.get()))));
        context.m_255272_(CLUSTER_FLOURISHING_CONFIGURED, (Object)new PlacedFeature((Holder)configured.m_254902_(WorldgenRegistry.NATURAL_CONFIGURED_FLOURISHING_TREE).get(), VegetationPlacements.m_195481_((PlacementModifier)CountPlacement.m_191628_((int)6), (Block)((Block)BlockRegistry.FLOURISHING_SAPLING.get()))));
        context.m_255272_(CLUSTER_VEXING_CONFIGURED, (Object)new PlacedFeature((Holder)configured.m_254902_(WorldgenRegistry.NATURAL_CONFIGURED_VEXING_TREE).get(), VegetationPlacements.m_195481_((PlacementModifier)CountPlacement.m_191628_((int)6), (Block)((Block)BlockRegistry.VEXING_SAPLING.get()))));
    }

    public static ResourceKey<Feature<?>> registerFeatureKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256833_, (ResourceLocation)new ResourceLocation("ars_elemental", name));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerConfKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("ars_elemental", name));
    }

    public static ResourceKey<PlacedFeature> registerPlacedKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("ars_elemental", name));
    }

    public static class Biomes {
        public static final String FLASHING_FOREST_ID = "flashing_forest";
        public static final String BLAZING_FOREST_ID = "blazing_forest";
        public static final String CASCADING_FOREST_ID = "cascading_forest";
        public static final String FLOURISHING_FOREST_ID = "flourishing_forest";
        public static final ResourceKey<Biome> FLASHING_FOREST_KEY = Biomes.register("flashing_forest");
        public static final ResourceKey<Biome> BLAZING_FOREST_KEY = Biomes.register("blazing_forest");
        public static final ResourceKey<Biome> CASCADING_FOREST_KEY = Biomes.register("cascading_forest");
        public static final ResourceKey<Biome> FLOURISHING_FOREST_KEY = Biomes.register("flourishing_forest");
        public static final ResourceLocation[] ArchwoodBiomes = new ResourceLocation[]{FLASHING_FOREST_KEY.m_135782_(), BLAZING_FOREST_KEY.m_135782_(), CASCADING_FOREST_KEY.m_135782_(), FLOURISHING_FOREST_KEY.m_135782_()};

        public static ResourceKey<Biome> register(String name) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)ArsElemental.prefix(name));
        }

        public static void registerBiomes(BootstapContext<Biome> context) {
            BiomeRegistry.bootstrap(context);
            context.m_255272_(FLASHING_FOREST_KEY, (Object)Biomes.flashingArchwoodForest(context));
            context.m_255272_(BLAZING_FOREST_KEY, (Object)Biomes.blazingArchwoodForest(context));
            context.m_255272_(CASCADING_FOREST_KEY, (Object)Biomes.cascadingArchwoodForest(context));
            context.m_255272_(FLOURISHING_FOREST_KEY, (Object)Biomes.flourishArchwoodForest(context));
        }

        public static Biome flashingArchwoodForest(BootstapContext<Biome> context) {
            MobSpawnSettings.Builder spawnBuilder = Biomes.archwoodSpawns();
            spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.FLASHING_WEALD_WALKER.get(), 3, 1, 3));
            BiomeGenerationSettings.Builder biomeBuilder = Biomes.getArchwoodBiomeBuilder(CLUSTER_FLASHING_CONFIGURED, context);
            return new Biome.BiomeBuilder().m_264558_(true).m_47611_(0.9f).m_47609_(0.4f).m_47601_(biomeBuilder.m_255380_()).m_47605_(spawnBuilder.m_48381_()).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(7978751).m_48037_(329011).m_48040_(7978751).m_48045_(13414701).m_48043_(13084948).m_48019_(12638463).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)((Holder)SoundRegistry.ARIA_BIBLIO.getHolder().get()))).m_48018_()).m_47592_();
        }

        private static Biome blazingArchwoodForest(BootstapContext<Biome> context) {
            MobSpawnSettings.Builder spawnBuilder = Biomes.archwoodSpawns();
            spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.ENTITY_BLAZING_WEALD.get(), 3, 1, 1));
            BiomeGenerationSettings.Builder biomeBuilder = Biomes.getArchwoodBiomeBuilder(CLUSTER_BLAZING_CONFIGURED, context);
            return new Biome.BiomeBuilder().m_264558_(true).m_47611_(0.4f).m_47609_(0.9f).m_47601_(biomeBuilder.m_255380_()).m_47605_(spawnBuilder.m_48381_()).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(7978751).m_48037_(329011).m_48040_(7978751).m_48045_(16077890).m_48043_(2210437).m_48019_(12638463).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)((Holder)SoundRegistry.ARIA_BIBLIO.getHolder().get()))).m_48018_()).m_47592_();
        }

        private static Biome cascadingArchwoodForest(BootstapContext<Biome> context) {
            MobSpawnSettings.Builder spawnBuilder = Biomes.archwoodSpawns();
            spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.ENTITY_CASCADING_WEALD.get(), 3, 1, 1));
            BiomeGenerationSettings.Builder biomeBuilder = Biomes.getArchwoodBiomeBuilder(CLUSTER_CASCADING_CONFIGURED, context);
            return new Biome.BiomeBuilder().m_264558_(true).m_47611_(0.9f).m_47609_(0.7f).m_47601_(biomeBuilder.m_255380_()).m_47605_(spawnBuilder.m_48381_()).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(7978751).m_48037_(329011).m_48040_(7978751).m_48045_(1142955).m_48043_(2210437).m_48019_(12638463).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)((Holder)SoundRegistry.ARIA_BIBLIO.getHolder().get()))).m_48018_()).m_47592_();
        }

        private static Biome flourishArchwoodForest(BootstapContext<Biome> context) {
            MobSpawnSettings.Builder spawnBuilder = Biomes.archwoodSpawns();
            spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.ENTITY_FLOURISHING_WEALD.get(), 3, 1, 1));
            BiomeGenerationSettings.Builder biomeBuilder = Biomes.getArchwoodBiomeBuilder(CLUSTER_FLOURISHING_CONFIGURED, context);
            return new Biome.BiomeBuilder().m_264558_(true).m_47611_(0.8f).m_47609_(0.7f).m_47601_(biomeBuilder.m_255380_()).m_47605_(spawnBuilder.m_48381_()).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(7978751).m_48037_(329011).m_48040_(7978751).m_48045_(1346066).m_48043_(2210437).m_48019_(12638463).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)((Holder)SoundRegistry.ARIA_BIBLIO.getHolder().get()))).m_48018_()).m_47592_();
        }

        private static MobSpawnSettings.Builder archwoodSpawns() {
            MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
            spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.STARBUNCLE_TYPE.get(), 2, 3, 5));
            spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.ENTITY_DRYGMY.get(), 2, 1, 3));
            spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.WHIRLISPRIG_TYPE.get(), 2, 1, 3));
            BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
            BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
            return spawnBuilder;
        }

        private static BiomeGenerationSettings.Builder getArchwoodBiomeBuilder(ResourceKey<PlacedFeature> archwoodCluster, BootstapContext<Biome> context) {
            BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
            BiomeRegistry.globalOverworldGeneration((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeDefaultFeatures.m_126826_((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeDefaultFeatures.m_126816_((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeRegistry.softDisks((BiomeGenerationSettings.Builder)biomeBuilder);
            biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195421_);
            BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
            biomeBuilder.m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, WorldgenRegistry.PLACED_LIGHTS);
            biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, archwoodCluster);
            biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WorldgenRegistry.PLACED_MOJANK_GRASS);
            biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WorldgenRegistry.PLACED_MOJANK_FLOWERS);
            return biomeBuilder;
        }
    }
}

