/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.recipe;

import alexthw.ars_elemental.registry.ModRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.setup.registry.RegistryHelper;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeadCutRecipe
extends CustomRecipe {
    public ResourceLocation mob;
    public ItemStack result;
    public int chance;

    public HeadCutRecipe(ItemStack result, ResourceLocation mob, int chance, ResourceLocation pId) {
        super(pId, CraftingBookCategory.MISC);
        this.mob = mob;
        this.result = result;
        this.chance = chance;
    }

    public boolean matches(@NotNull CraftingContainer pContainer, @NotNull Level pLevel) {
        return false;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer pContainer, @NotNull RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRegistry.HEAD_CUT_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRegistry.HEAD_CUT.get();
    }

    public JsonElement asRecipe() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", "ars_elemental:head_cut");
        jsonobject.addProperty("mob", this.mob.toString());
        jsonobject.addProperty("drop_chance", (Number)this.chance);
        JsonObject resultObj = new JsonObject();
        resultObj.addProperty("item", RegistryHelper.getRegistryName((Item)this.result.m_41720_()).toString());
        jsonobject.add("output", (JsonElement)resultObj);
        return jsonobject;
    }

    public static class Serializer
    implements RecipeSerializer<HeadCutRecipe> {
        @NotNull
        public HeadCutRecipe fromJson(@NotNull ResourceLocation pRecipeId, @NotNull JsonObject json) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            ResourceLocation mob = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)json, (String)"mob"));
            int chance = GsonHelper.m_13927_((JsonObject)json, (String)"drop_chance");
            return new HeadCutRecipe(output, mob, chance, pRecipeId);
        }

        @Nullable
        public HeadCutRecipe fromNetwork(@NotNull ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            ItemStack output = pBuffer.m_130267_();
            ResourceLocation mob = pBuffer.m_130281_();
            int chance = pBuffer.readInt();
            return new HeadCutRecipe(output, mob, chance, pRecipeId);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, HeadCutRecipe pRecipe) {
            pBuffer.m_130055_(pRecipe.result);
            pBuffer.m_130085_(pRecipe.mob);
            pBuffer.writeInt(pRecipe.chance);
        }
    }
}

