/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.event;

import alexthw.ars_elemental.registry.ModAdvTriggers;
import alexthw.ars_elemental.registry.ModRegistry;
import com.hollingsworth.arsnouveau.common.entity.EntityHomingProjectileSpell;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.items.EnchantersShield;
import com.hollingsworth.arsnouveau.common.spell.casters.ReactiveCaster;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.hollingsworth.arsnouveau.setup.registry.EnchantmentRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ars_elemental")
public class ShieldEvents {
    @SubscribeEvent
    public static void onBlock(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (projectile instanceof EntityProjectileSpell) {
            int level;
            ItemStack stack;
            Player player;
            EntityHitResult result;
            EntityProjectileSpell projectileSpell = (EntityProjectileSpell)projectile;
            projectile = event.getRayTraceResult();
            if (projectile instanceof EntityHitResult && (projectile = (result = (EntityHitResult)projectile).m_82443_()) instanceof Player && (player = (Player)projectile).m_21254_() && (stack = player.m_21206_()).m_41720_() instanceof EnchantersShield && (double)(level = stack.getEnchantmentLevel((Enchantment)ModRegistry.MIRROR.get())) * 0.25 >= Math.random()) {
                projectileSpell.m_20256_(projectileSpell.m_20184_().m_82548_().m_82520_(0.0, 0.2, 0.0));
                if (projectileSpell instanceof EntityHomingProjectileSpell) {
                    EntityHomingProjectileSpell homing = (EntityHomingProjectileSpell)projectileSpell;
                    if (level > 3) {
                        homing.getIgnored().add(e -> e == player);
                    }
                }
                if (player instanceof ServerPlayer) {
                    ModAdvTriggers.MIRROR.m_222618_((ServerPlayer)player);
                    float pay = (float)projectileSpell.spellResolver.getResolveCost() / ((float)level * 2.0f);
                    CapabilityRegistry.getMana((LivingEntity)player).ifPresent(mana -> mana.removeMana((double)pay));
                    player.m_36335_().m_41524_(stack.m_41720_(), 20 * level);
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockReactive(ShieldBlockEvent event) {
        Player player;
        block5: {
            block4: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block4;
                player = (Player)livingEntity;
                if (!player.m_20193_().f_46443_) break block5;
            }
            return;
        }
        ItemStack s = player.m_21206_();
        if (s.m_41720_() instanceof EnchantersShield && (double)s.getEnchantmentLevel((Enchantment)EnchantmentRegistry.REACTIVE_ENCHANTMENT.get()) * 0.25 >= Math.random() && new ReactiveCaster(s).getSpell().isValid()) {
            ReactiveCaster reactiveCaster = new ReactiveCaster(s);
            reactiveCaster.castSpell(player.m_20193_(), (LivingEntity)player, InteractionHand.OFF_HAND, null);
        }
    }

    @SubscribeEvent
    public static void onSonicImpact(LivingAttackEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player) || !((livingEntity = (player = (Player)livingEntity).m_20193_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)livingEntity;
        ItemStack s = player.m_21206_();
        if (s.m_41720_() instanceof EnchantersShield && player.m_21254_() && (double)s.getEnchantmentLevel((Enchantment)ModRegistry.MIRROR.get()) * 0.25 >= Math.random() && event.getSource().m_7270_() != null && event.getSource().m_276093_(DamageTypes.f_268679_)) {
            Vec3 vec3 = player.m_20252_(1.0f);
            Vec3 vec31 = event.getSource().m_7270_().m_82505_(player.m_20182_()).m_82541_();
            vec31 = new Vec3(vec31.f_82479_, 0.0, vec31.f_82481_);
            if (vec31.m_82526_(vec3) < 0.0) {
                ShieldEvents.reflectSonicBoom(event, player, s, level);
            }
        }
    }

    private static void reflectSonicBoom(LivingAttackEvent event, Player player, ItemStack stack, ServerLevel level) {
        event.setCanceled(true);
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity reflectTo = (LivingEntity)entity;
        Vec3 vec3 = player.m_146892_();
        Vec3 vec31 = reflectTo.m_20182_().m_82520_(0.0, (double)1.6f, 0.0).m_82546_(vec3);
        Vec3 vec32 = vec31.m_82541_();
        for (int i = 1; i < Mth.m_14107_((double)vec31.m_82553_()) + 7; ++i) {
            Vec3 vec33 = vec3.m_82549_(vec32.m_82490_((double)i));
            level.m_8767_((ParticleOptions)ParticleTypes.f_235902_, vec33.f_82479_, vec33.f_82480_, vec33.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
        player.m_5496_(SoundEvents.f_215771_, 3.0f, 1.0f);
        reflectTo.m_6469_(player.m_269291_().m_269285_((Entity)player), 10.0f);
        double d1 = 0.5 * (1.0 - reflectTo.m_21133_(Attributes.f_22278_));
        double d0 = 2.5 * (1.0 - reflectTo.m_21133_(Attributes.f_22278_));
        reflectTo.m_5997_(vec32.m_7096_() * d0, vec32.m_7098_() * d1, vec32.m_7094_() * d0);
        CapabilityRegistry.getMana((LivingEntity)player).ifPresent(mana -> mana.removeMana(150.0));
        player.m_36335_().m_41524_(stack.m_41720_(), 20 * stack.getEnchantmentLevel((Enchantment)ModRegistry.MIRROR.get()));
        player.m_5810_();
    }
}

