/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.client.patchouli;

import alexthw.ars_elemental.recipe.ElementalArmorRecipe;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ElementalArmorProcessor
implements IComponentProcessor {
    private ElementalArmorRecipe recipe;

    public void setup(Level level, IVariableProvider variables) {
        String recipeID;
        RecipeManager manager = level.m_7465_();
        Object var6_5 = manager.m_44043_(new ResourceLocation(recipeID = variables.get("recipe").asString())).orElse(null);
        if (var6_5 instanceof ElementalArmorRecipe) {
            ElementalArmorRecipe ear;
            this.recipe = ear = (ElementalArmorRecipe)var6_5;
        }
    }

    @NotNull
    public IVariable process(Level level, String key) {
        if (this.recipe == null) {
            return IVariable.empty();
        }
        if (key.equals("reagent")) {
            return IVariable.wrapList((Iterable)Arrays.stream(this.recipe.reagent.m_43908_()).map(IVariable::from).collect(Collectors.toList()));
        }
        if (key.equals("recipe")) {
            return IVariable.wrap((String)this.recipe.m_6423_().toString());
        }
        if (key.equals("tier")) {
            return IVariable.wrap((String)this.recipe.getOutputComponent().getString());
        }
        if (key.equals("output")) {
            return IVariable.from((Object)this.recipe.result);
        }
        if (key.equals("footer")) {
            return IVariable.wrap((String)this.recipe.result.m_41720_().m_5524_());
        }
        return IVariable.empty();
    }
}

