/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.forge.compat;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistries;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.api.forge.event.ForgeHeartRegistryEvent;
import terrails.colorfulhearts.api.heart.drawing.HeartDrawing;
import terrails.colorfulhearts.api.heart.drawing.OverlayHeart;

public class UndergardenCompat {
    private static final ResourceLocation VIRULENCE_OVERLAY = new ResourceLocation("undergarden", "virulence_hearts");

    public UndergardenCompat(IEventBus bus) {
        MinecraftForge.EVENT_BUS.addListener(this::cancelOverlay);
        bus.addListener(this::registerEffectHeart);
    }

    private void cancelOverlay(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay().id().equals((Object)VIRULENCE_OVERLAY)) {
            event.setCanceled(true);
        }
    }

    public void registerEffectHeart(ForgeHeartRegistryEvent event) {
        ForgeRegistries.MOB_EFFECTS.getHolder(new ResourceLocation("undergarden", "virulence")).ifPresent(effectHolder -> {
            CColorfulHearts.LOGGER.info("Registering custom hearts for virulence from mod undergarden");
            final ResourceLocation heartTexture = new ResourceLocation("undergarden", "textures/gui/virulence_hearts.png");
            final ResourceLocation heartId = new ResourceLocation("colorfulhearts", "virulence_vanilla");
            HeartDrawing vanilla = new HeartDrawing(){

                @Override
                public void draw(GuiGraphics guiGraphics, int x, int y, boolean half, boolean hardcore, boolean highlight) {
                    LocalPlayer player = Minecraft.m_91087_().f_91074_;
                    assert (player != null);
                    Gui.HeartType heartType = Gui.HeartType.m_168732_((Player)Minecraft.m_91087_().f_91074_);
                    guiGraphics.m_280218_(heartTexture, x, y, heartType.m_168734_(half, highlight), hardcore ? 45 : 0, 9, 9);
                }

                @Override
                public ResourceLocation getId() {
                    return heartId;
                }
            };
            event.registerOverlayHeart(OverlayHeart.build(new ResourceLocation("colorfulhearts", "virulence"), player -> player.m_21023_((MobEffect)effectHolder.get())).addHealth(vanilla, 0.45f, 0.4f, 0.4f).addAbsorption(HeartDrawing.colorBlend(vanilla, heartId.m_266382_("_absorption"), 1.0f, 1.0f, 1.0f, 0.15f, 1, 771), HeartDrawing.colorBlend(vanilla, heartId.m_266382_("_absorption_2"), 1.0f, 0.85f, 0.85f, 0.5f, 1, 771)).finish());
            CColorfulHearts.LOGGER.debug("Registered custom hearts for virulence from mod undergarden");
        });
    }
}

