/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.tconstruct.shared.TinkerEffects;
import slimeknights.tconstruct.shared.effect.AntigravityEffect;
import slimeknights.tconstruct.tools.logic.DoubleJumpHandler;
import slimeknights.tconstruct.tools.logic.InteractionHandler;

public enum TinkerControlPacket implements IThreadsafePacket
{
    DOUBLE_JUMP,
    ANTIGRAVITY_JUMP,
    START_HELMET_INTERACT(TooltipKey.NORMAL),
    START_HELMET_INTERACT_SHIFT(TooltipKey.SHIFT),
    START_HELMET_INTERACT_CONTROL(TooltipKey.CONTROL),
    START_HELMET_INTERACT_ALT(TooltipKey.ALT),
    STOP_HELMET_INTERACT,
    START_LEGGINGS_INTERACT(TooltipKey.NORMAL),
    START_LEGGINGS_INTERACT_SHIFT(TooltipKey.SHIFT),
    START_LEGGINGS_INTERACT_CONTROL(TooltipKey.CONTROL),
    START_LEGGINGS_INTERACT_ALT(TooltipKey.ALT),
    STOP_LEGGINGS_INTERACT;

    private final TooltipKey modifier;

    private TinkerControlPacket() {
        this(TooltipKey.UNKNOWN);
    }

    public static TinkerControlPacket getStartHelmetInteract(TooltipKey key) {
        return switch (key) {
            case TooltipKey.SHIFT -> START_HELMET_INTERACT_SHIFT;
            case TooltipKey.CONTROL -> START_HELMET_INTERACT_CONTROL;
            case TooltipKey.ALT -> START_HELMET_INTERACT_ALT;
            default -> START_HELMET_INTERACT;
        };
    }

    public static TinkerControlPacket getStartLeggingsInteract(TooltipKey key) {
        return switch (key) {
            case TooltipKey.SHIFT -> START_LEGGINGS_INTERACT_SHIFT;
            case TooltipKey.CONTROL -> START_LEGGINGS_INTERACT_CONTROL;
            case TooltipKey.ALT -> START_LEGGINGS_INTERACT_ALT;
            default -> START_LEGGINGS_INTERACT;
        };
    }

    public static TinkerControlPacket read(FriendlyByteBuf buffer) {
        return (TinkerControlPacket)buffer.m_130066_(TinkerControlPacket.class);
    }

    public void encode(FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130068_((Enum)this);
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player != null) {
            switch (this) {
                case DOUBLE_JUMP: {
                    DoubleJumpHandler.extraJump((Player)player);
                    break;
                }
                case ANTIGRAVITY_JUMP: {
                    ((AntigravityEffect)((Object)TinkerEffects.antigravity.get())).antigravityJump((Player)player);
                    break;
                }
                case START_HELMET_INTERACT: 
                case START_HELMET_INTERACT_SHIFT: 
                case START_HELMET_INTERACT_CONTROL: 
                case START_HELMET_INTERACT_ALT: {
                    InteractionHandler.startArmorInteract((Player)player, EquipmentSlot.HEAD, this.modifier);
                    break;
                }
                case STOP_HELMET_INTERACT: {
                    InteractionHandler.stopArmorInteract((Player)player, EquipmentSlot.HEAD);
                    break;
                }
                case START_LEGGINGS_INTERACT: 
                case START_LEGGINGS_INTERACT_SHIFT: 
                case START_LEGGINGS_INTERACT_CONTROL: 
                case START_LEGGINGS_INTERACT_ALT: {
                    InteractionHandler.startArmorInteract((Player)player, EquipmentSlot.LEGS, this.modifier);
                    break;
                }
                case STOP_LEGGINGS_INTERACT: {
                    InteractionHandler.stopArmorInteract((Player)player, EquipmentSlot.LEGS);
                }
            }
        }
    }

    private TinkerControlPacket(TooltipKey modifier) {
        this.modifier = modifier;
    }
}

