/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.tools;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.joml.Vector3f;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;

public class MaterialModel
implements IUnbakedGeometry<MaterialModel> {
    public static final IGeometryLoader<MaterialModel> LOADER = MaterialModel::deserialize;
    @Nullable
    private final MaterialVariantId material;
    private final int index;
    private final Vec2 offset;

    public static void validateMaterialTextures(IGeometryBakingContext owner, Function<Material, TextureAtlasSprite> spriteGetter, String textureName, @Nullable MaterialVariantId material) {
        Material texture = owner.getMaterial(textureName);
        if (!MissingTextureAtlasSprite.m_118071_().equals((Object)texture.m_119203_())) {
            if (material == null) {
                MaterialRenderInfoLoader.INSTANCE.getAllRenderInfos().forEach(info -> info.getSprite(texture, spriteGetter));
            } else {
                MaterialRenderInfoLoader.INSTANCE.getRenderInfo(material).ifPresent(info -> info.getSprite(texture, spriteGetter));
            }
        }
    }

    public static MaterialRenderInfo.TintedSprite getMaterialSprite(Function<Material, TextureAtlasSprite> spriteGetter, Material texture, MaterialVariantId material) {
        Optional<MaterialRenderInfo> optional = MaterialRenderInfoLoader.INSTANCE.getRenderInfo(material);
        if (optional.isPresent()) {
            return optional.get().getSprite(texture, spriteGetter);
        }
        return new MaterialRenderInfo.TintedSprite(spriteGetter.apply(texture), -1, 0);
    }

    public static List<BakedQuad> getQuadsForMaterial(Function<Material, TextureAtlasSprite> spriteGetter, Material texture, MaterialVariantId material, int tintIndex, Transformation transformation, @Nullable ItemLayerPixels pixels) {
        MaterialRenderInfo.TintedSprite sprite = MaterialModel.getMaterialSprite(spriteGetter, texture, material);
        return MantleItemLayerModel.getQuadsForSprite((int)sprite.color(), (int)tintIndex, (TextureAtlasSprite)sprite.sprite(), (Transformation)transformation, (int)sprite.emissivity(), (ItemLayerPixels)pixels);
    }

    private static BakedModel bakeInternal(IGeometryBakingContext owner, Function<Material, TextureAtlasSprite> spriteGetter, Transformation transform, MaterialVariantId material, int index, ItemOverrides overrides) {
        MaterialRenderInfo.TintedSprite materialSprite = MaterialModel.getMaterialSprite(spriteGetter, owner.getMaterial("texture"), material);
        CompositeModel.Baked.Builder builder = CompositeModel.Baked.builder((IGeometryBakingContext)owner, (TextureAtlasSprite)materialSprite.sprite(), (ItemOverrides)overrides, (ItemTransforms)owner.getTransforms());
        builder.addQuads(MantleItemLayerModel.getDefaultRenderType((IGeometryBakingContext)owner), (Collection)MantleItemLayerModel.getQuadsForSprite((int)materialSprite.color(), (int)index, (TextureAtlasSprite)materialSprite.sprite(), (Transformation)transform, (int)materialSprite.emissivity()));
        return builder.build();
    }

    public BakedModel bake(IGeometryBakingContext owner, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides vanillaOverrides, ResourceLocation modelLocation) {
        if (((Boolean)Config.CLIENT.logMissingMaterialTextures.get()).booleanValue()) {
            MaterialModel.validateMaterialTextures(owner, spriteGetter, "texture", this.material);
        }
        Transformation transforms = Vec2.f_82462_.m_82476_(this.offset) ? Transformation.m_121093_() : new Transformation(new Vector3f(this.offset.f_82470_ / 16.0f, -this.offset.f_82471_ / 16.0f, 0.0f), null, null, null);
        ItemOverrides overrides = ItemOverrides.f_111734_;
        if (this.material == null) {
            overrides = new MaterialOverrideHandler(owner, this.index, transforms);
        }
        return MaterialModel.bakeInternal(owner, spriteGetter, transforms, Objects.requireNonNullElse(this.material, IMaterial.UNKNOWN_ID), this.index, overrides);
    }

    public static MaterialModel deserialize(JsonObject json, JsonDeserializationContext context) {
        int index = GsonHelper.m_13824_((JsonObject)json, (String)"index", (int)0);
        MaterialVariantId material = null;
        if (json.has("material")) {
            material = MaterialVariantId.fromJson(json, "material");
        }
        Vec2 offset = Vec2.f_82462_;
        if (json.has("offset")) {
            offset = MaterialModel.getVec2(json, "offset");
        }
        return new MaterialModel(material, index, offset);
    }

    public static Vec2 getVec2(JsonObject json, String name) {
        JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)name);
        if (array.size() != 2) {
            throw new JsonParseException("Expected 2 " + name + " values, found: " + array.size());
        }
        float[] vec = new float[2];
        for (int i = 0; i < 2; ++i) {
            vec[i] = GsonHelper.m_13888_((JsonElement)array.get(i), (String)(name + "[" + i + "]"));
        }
        return new Vec2(vec[0], vec[1]);
    }

    public MaterialModel(@Nullable MaterialVariantId material, int index, Vec2 offset) {
        this.material = material;
        this.index = index;
        this.offset = offset;
    }

    private static final class MaterialOverrideHandler
    extends ItemOverrides {
        private final Map<MaterialVariantId, BakedModel> cache = new ConcurrentHashMap<MaterialVariantId, BakedModel>();
        private final IGeometryBakingContext owner;
        private final int index;
        private final Transformation itemTransform;

        private MaterialOverrideHandler(IGeometryBakingContext owner, int index, Transformation itemTransform) {
            this.owner = owner;
            this.index = index;
            this.itemTransform = itemTransform;
        }

        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            MaterialVariantId material = IMaterialItem.getMaterialFromStack(stack);
            return this.cache.computeIfAbsent(material, this::bakeDynamic);
        }

        private BakedModel bakeDynamic(MaterialVariantId material) {
            return MaterialModel.bakeInternal(this.owner, Material::m_119204_, this.itemTransform, material, this.index, ItemOverrides.f_111734_);
        }
    }
}

