/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.generators.common.tile.TileEntityBioGenerator;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;

@NothingNullByDefault
public class RenderBioGenerator
extends MekanismTileEntityRenderer<TileEntityBioGenerator> {
    private static final Map<Direction, Int2ObjectMap<MekanismRenderer.Model3D>> fuelModels = new EnumMap<Direction, Int2ObjectMap<MekanismRenderer.Model3D>>(Direction.class);
    private static final int stages = 40;

    public static void resetCachedModels() {
        fuelModels.clear();
    }

    public RenderBioGenerator(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void render(TileEntityBioGenerator tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        matrix.m_85836_();
        FluidStack fluid = tile.bioFuelTank.getFluid();
        float fluidScale = (float)fluid.getAmount() / (float)tile.bioFuelTank.getCapacity();
        MekanismRenderer.renderObject((MekanismRenderer.Model3D)this.getModel(fluid, tile.getDirection(), fluidScale), (PoseStack)matrix, (VertexConsumer)renderer.m_6299_(Sheets.m_110792_()), (int)MekanismRenderer.getColorARGB((FluidStack)fluid, (float)fluidScale), (int)0xF000F0, (int)overlayLight, (RenderResizableCuboid.FaceDisplay)RenderResizableCuboid.FaceDisplay.FRONT, (Camera)this.getCamera(), (BlockPos)tile.m_58899_());
        matrix.m_85849_();
    }

    protected String getProfilerSection() {
        return "bioGenerator";
    }

    public boolean shouldRender(TileEntityBioGenerator tile, Vec3 camera) {
        return !tile.bioFuelTank.isEmpty() && super.m_142756_((BlockEntity)tile, camera);
    }

    private MekanismRenderer.Model3D getModel(FluidStack fluid, Direction side, float fluidScale) {
        return (MekanismRenderer.Model3D)fuelModels.computeIfAbsent(side, s -> new Int2ObjectOpenHashMap()).computeIfAbsent(ModelRenderer.getStage((FluidStack)fluid, (int)40, (double)fluidScale), stage -> {
            Direction opposite = side.m_122424_();
            MekanismRenderer.Model3D model = new MekanismRenderer.Model3D().setTexture(MekanismRenderer.getFluidTexture((FluidStack)fluid, (MekanismRenderer.FluidTextureType)MekanismRenderer.FluidTextureType.STILL)).yBounds(0.4385f, 0.4385f + 0.4375f * ((float)stage / 40.0f)).setSideRender(dir -> dir == Direction.UP || dir == opposite);
            return switch (side) {
                case Direction.NORTH -> model.xBounds(0.188f, 0.821f).zBounds(0.499f, 0.875f);
                case Direction.SOUTH -> model.xBounds(0.188f, 0.821f).zBounds(0.125f, 0.499f);
                case Direction.WEST -> model.xBounds(0.499f, 0.875f).zBounds(0.187f, 0.821f);
                case Direction.EAST -> model.xBounds(0.125f, 0.499f).zBounds(0.186f, 0.821f);
                default -> model;
            };
        });
    }
}

