/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.network;

import net.blay09.mods.craftingtweaks.CraftingTweaksProviderManager;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.GridTransferHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class TransferStackMessage {
    private final ResourceLocation id;
    private final int slotNumber;

    public TransferStackMessage(ResourceLocation id, int slotNumber) {
        this.id = id;
        this.slotNumber = slotNumber;
    }

    public static void encode(TransferStackMessage message, FriendlyByteBuf buf) {
        buf.m_130085_(message.id);
        buf.writeInt(message.slotNumber);
    }

    public static TransferStackMessage decode(FriendlyByteBuf buf) {
        ResourceLocation id = buf.m_130281_();
        int slotNumber = buf.readInt();
        return new TransferStackMessage(id, slotNumber);
    }

    public static void handle(ServerPlayer player, TransferStackMessage message) {
        if (player == null) {
            return;
        }
        AbstractContainerMenu menu = player.f_36096_;
        if (menu == null || message.slotNumber < 0 || message.slotNumber >= menu.f_38839_.size()) {
            return;
        }
        CraftingTweaksProviderManager.getCraftingGrid(menu, message.id).ifPresent(grid -> {
            Slot slot;
            GridTransferHandler<AbstractContainerMenu> transferHandler = grid.transferHandler();
            if (!transferHandler.canTransferFrom((Player)player, menu, slot = (Slot)menu.f_38839_.get(message.slotNumber), (CraftingGrid)grid) || slot instanceof ResultSlot) {
                return;
            }
            ItemStack slotStack = slot.m_7993_();
            if (!slotStack.m_41619_() && slot.m_8010_((Player)player)) {
                ItemStack oldStack = slotStack.m_41777_();
                if (!transferHandler.transferIntoGrid((CraftingGrid)grid, (Player)player, menu, slot)) {
                    return;
                }
                slot.m_40234_(slotStack, oldStack);
                if (slotStack.m_41613_() <= 0) {
                    slot.m_5852_(ItemStack.f_41583_);
                } else {
                    slot.m_6654_();
                }
                if (slotStack.m_41613_() != oldStack.m_41613_()) {
                    slot.m_142406_((Player)player, slotStack);
                }
            }
        });
    }
}

