/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle;

import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyTransportBehavior;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.DepositItemState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.FindItemState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.GoToBedState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.HarvestBerryState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.StarbyState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.TakeItemState;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class DecideStarbyActionState
extends StarbyState {
    public DecideStarbyActionState(Starbuncle starbuncle, StarbyTransportBehavior behavior) {
        super(starbuncle, behavior);
    }

    @Override
    @Nullable
    public StarbyState tick() {
        if (!this.starbuncle.isTamed() || this.starbuncle.m_20159_() || this.starbuncle.m_21525_()) {
            return null;
        }
        BlockPos bedPos = this.behavior.getBedPos();
        if (bedPos != null && this.starbuncle.getBedBackoff() <= 0 && this.behavior.isBedPowered()) {
            return new GoToBedState(this.starbuncle, this.behavior, new DecideStarbyActionState(this.starbuncle, this.behavior));
        }
        BlockPos storePos = this.behavior.getValidStorePos(this.starbuncle.getHeldStack());
        boolean pickupDisabled = this.behavior.isPickupDisabled();
        if (storePos != null) {
            return new DepositItemState(this.starbuncle, this.behavior, storePos);
        }
        if (this.behavior.takeItemBackoff <= 0) {
            BlockPos takePos;
            BlockPos blockPos = takePos = this.starbuncle.getHeldStack().m_41619_() ? this.behavior.getValidTakePos() : null;
            if (takePos != null) {
                return new TakeItemState(this.starbuncle, this.behavior, takePos);
            }
            this.behavior.takeItemBackoff = 5 + this.starbuncle.m_217043_().m_188503_(20);
        }
        if (!pickupDisabled && this.starbuncle.getStarbuncleWithSpace() != null) {
            if (this.behavior.findItemBackoff <= 0) {
                List<ItemEntity> nearbyItems = FindItemState.nearbyItems(this.starbuncle, this.behavior);
                if (!nearbyItems.isEmpty()) {
                    return new FindItemState(this.starbuncle, this.behavior, nearbyItems);
                }
                this.behavior.findItemBackoff = 30 + this.starbuncle.m_217043_().m_188503_(30);
            }
            if (this.behavior.berryBackoff <= 0) {
                BlockPos takeBerryPos = HarvestBerryState.getNearbyManaBerry(this.starbuncle.f_19853_, this.starbuncle);
                if (takeBerryPos != null && this.behavior.getValidStorePos(new ItemStack(BlockRegistry.SOURCEBERRY_BUSH)) != null) {
                    return new HarvestBerryState(this.starbuncle, this.behavior, takeBerryPos);
                }
                this.behavior.berryBackoff = 20 + this.starbuncle.m_217043_().m_188503_(20);
            }
        }
        if (bedPos != null && this.starbuncle.getBedBackoff() <= 0) {
            return new GoToBedState(this.starbuncle, this.behavior, new DecideStarbyActionState(this.starbuncle, this.behavior));
        }
        return super.tick();
    }
}

