/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.loot;

import com.buuz135.sushigocrafting.loot.ItemWeightedItem;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class SeedsLootModifier
extends LootModifier {
    public static final Supplier<Codec<SeedsLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> SeedsLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, SeedsLootModifier::new)));
    private final List<ItemWeightedItem> seeds = new ArrayList<ItemWeightedItem>();

    public SeedsLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
        this.seeds.add(new ItemWeightedItem(Items.f_42404_, 150));
        this.seeds.add(new ItemWeightedItem((Item)SushiContent.Items.RICE_SEEDS.get(), 25));
        this.seeds.add(new ItemWeightedItem((Item)SushiContent.Items.SESAME_SEEDS.get(), 10));
        this.seeds.add(new ItemWeightedItem((Item)SushiContent.Items.WASABI_SEEDS.get(), 25));
        this.seeds.add(new ItemWeightedItem((Item)SushiContent.Items.SOY_SEEDS.get(), 25));
        this.seeds.add(new ItemWeightedItem((Item)SushiContent.Items.CUCUMBER_SEEDS.get(), 25));
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ObjectArrayList customLoot = new ObjectArrayList();
        for (ItemStack stack : generatedLoot) {
            if (stack.m_41720_() == Items.f_42404_) {
                WeightedRandom.m_216822_((RandomSource)context.m_230907_(), this.seeds).ifPresent(itemWeightedItem -> {
                    ItemStack weightedStack = new ItemStack((ItemLike)itemWeightedItem.getStack());
                    weightedStack.m_41764_(stack.m_41613_());
                    customLoot.add((Object)weightedStack);
                });
                continue;
            }
            customLoot.add((Object)stack);
        }
        return customLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

