/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.util;

import com.google.common.collect.Lists;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.entity.block.AbstractMateriallyTexturedBlockEntity;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;

public class BlockUtils {
    private BlockUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: BlockUtils. This is a utility class");
    }

    public static Component getHoverName(Block block) {
        return new ItemStack((ItemLike)block).m_41786_();
    }

    public static List<ItemStack> getMaterializedItemStack(@NotNull LootParams.Builder builder) {
        ItemStack stack = BlockUtils.getMaterializedItemStack((Entity)builder.m_287159_(LootContextParams.f_81455_), (BlockEntity)builder.m_287159_(LootContextParams.f_81462_), (ItemStack s, AbstractMateriallyTexturedBlockEntity e) -> s);
        if (!stack.m_41619_()) {
            return Lists.newArrayList((Object[])new ItemStack[]{stack});
        }
        return Collections.emptyList();
    }

    public static ItemStack getMaterializedItemStack(Entity entity, BlockGetter blockGetter, BlockPos blockPos) {
        return BlockUtils.getMaterializedItemStack(entity, blockGetter.m_7702_(blockPos), (ItemStack s, AbstractMateriallyTexturedBlockEntity e) -> s);
    }

    public static ItemStack getMaterializedItemStack(Entity entity, BlockEntity blockEntity) {
        return BlockUtils.getMaterializedItemStack(entity, blockEntity, (ItemStack s, AbstractMateriallyTexturedBlockEntity e) -> s);
    }

    public static List<ItemStack> getMaterializedItemStack(@NotNull LootParams.Builder builder, BiFunction<ItemStack, AbstractMateriallyTexturedBlockEntity, ItemStack> adapter) {
        ItemStack stack = BlockUtils.getMaterializedItemStack((Entity)builder.m_287159_(LootContextParams.f_81455_), (BlockEntity)builder.m_287159_(LootContextParams.f_81462_), adapter);
        if (!stack.m_41619_()) {
            return Lists.newArrayList((Object[])new ItemStack[]{stack});
        }
        return Collections.emptyList();
    }

    public static ItemStack getMaterializedItemStack(Entity entity, BlockGetter blockGetter, BlockPos blockPos, BiFunction<ItemStack, AbstractMateriallyTexturedBlockEntity, ItemStack> adapter) {
        return BlockUtils.getMaterializedItemStack(entity, blockGetter.m_7702_(blockPos), adapter);
    }

    public static ItemStack getMaterializedItemStack(Entity entity, BlockEntity blockEntity, BiFunction<ItemStack, AbstractMateriallyTexturedBlockEntity, ItemStack> adapter) {
        if (!(blockEntity instanceof AbstractMateriallyTexturedBlockEntity)) {
            return ItemStack.f_41583_;
        }
        AbstractMateriallyTexturedBlockEntity texturedBlockEntity = (AbstractMateriallyTexturedBlockEntity)blockEntity;
        MaterialTextureData materialTextureData = texturedBlockEntity.getTextureData();
        CompoundTag textureNbt = materialTextureData.serializeNBT();
        ItemStack result = new ItemStack((ItemLike)blockEntity.m_58900_().m_60734_());
        result.m_41784_().m_128365_("textureData", (Tag)textureNbt);
        return adapter.apply(result, (AbstractMateriallyTexturedBlockEntity)blockEntity);
    }
}

