/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.global;

import com.google.common.collect.ImmutableList;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.BrickBlock;
import com.ldtteam.domumornamentum.block.decorative.ExtraBlock;
import com.ldtteam.domumornamentum.block.decorative.FloatingCarpetBlock;
import java.util.List;
import java.util.Set;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.jetbrains.annotations.NotNull;

public class GlobalLootTableProvider
extends LootTableProvider {
    public GlobalLootTableProvider(PackOutput packOutput) {
        super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(GlobalLootTableEntries::new, LootContextParamSets.f_81421_)));
    }

    @NotNull
    public String m_6055_() {
        return "Default Block Loot Tables Provider";
    }

    private static final class GlobalLootTableEntries
    extends BlockLootSubProvider {
        private GlobalLootTableEntries() {
            super(Set.of(), FeatureFlags.f_244280_.m_247355_());
        }

        protected void m_245660_() {
            for (BrickBlock brickBlock : ModBlocks.getInstance().getBricks()) {
                this.m_245724_(brickBlock);
            }
            for (ExtraBlock extraBlock : ModBlocks.getInstance().getExtraTopBlocks()) {
                this.m_245724_(extraBlock);
            }
            for (FloatingCarpetBlock floatingCarpetBlock : ModBlocks.getInstance().getFloatingCarpets()) {
                this.m_245724_(floatingCarpetBlock);
            }
            this.m_245724_(ModBlocks.getInstance().getStandingBarrel());
            this.m_245724_(ModBlocks.getInstance().getLayingBarrel());
            this.m_245724_(ModBlocks.getInstance().getArchitectsCutter());
        }

        @NotNull
        protected Iterable<Block> getKnownBlocks() {
            return ImmutableList.builder().addAll(ModBlocks.getInstance().getBricks()).addAll(ModBlocks.getInstance().getExtraTopBlocks()).addAll(ModBlocks.getInstance().getFloatingCarpets()).add((Object)ModBlocks.getInstance().getStandingBarrel()).add((Object)ModBlocks.getInstance().getLayingBarrel()).add((Object)ModBlocks.getInstance().getArchitectsCutter()).build();
        }
    }
}

