/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.client;

import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.blockcommands.ISerializer;
import mcjty.lib.network.NetworkTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.xnet.XNet;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;

public class ControllerChannelClientInfo {
    @Nonnull
    private final String channelName;
    @Nonnull
    private final String publishedName;
    @Nonnull
    private final BlockPos pos;
    @Nonnull
    private final IChannelType channelType;
    private final boolean remote;
    private final int index;

    public ControllerChannelClientInfo(@Nonnull String channelName, @Nonnull String publishedName, @Nonnull BlockPos pos, @Nonnull IChannelType channelType, boolean remote, int index) {
        this.channelName = channelName;
        this.publishedName = publishedName;
        this.pos = pos;
        this.channelType = channelType;
        this.remote = remote;
        this.index = index;
    }

    public ControllerChannelClientInfo(@Nonnull FriendlyByteBuf buf) {
        this.channelName = NetworkTools.readStringUTF8((FriendlyByteBuf)buf);
        this.publishedName = NetworkTools.readStringUTF8((FriendlyByteBuf)buf);
        String id = buf.m_130136_(Short.MAX_VALUE);
        IChannelType t = XNet.xNetApi.findType(id);
        if (t == null) {
            throw new RuntimeException("Bad type: " + id);
        }
        this.channelType = t;
        this.pos = buf.m_130135_();
        this.remote = buf.readBoolean();
        this.index = buf.readInt();
    }

    public void writeToBuf(@Nonnull FriendlyByteBuf buf) {
        NetworkTools.writeStringUTF8((FriendlyByteBuf)buf, (String)this.channelName);
        NetworkTools.writeStringUTF8((FriendlyByteBuf)buf, (String)this.publishedName);
        buf.m_130070_(this.channelType.getID());
        buf.m_130064_(this.pos);
        buf.writeBoolean(this.remote);
        buf.writeInt(this.index);
    }

    @Nonnull
    public String getChannelName() {
        return this.channelName;
    }

    @Nonnull
    public String getPublishedName() {
        return this.publishedName;
    }

    @Nonnull
    public BlockPos getPos() {
        return this.pos;
    }

    @Nonnull
    public IChannelType getChannelType() {
        return this.channelType;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public static class Serializer
    implements ISerializer<ControllerChannelClientInfo> {
        public Function<FriendlyByteBuf, ControllerChannelClientInfo> getDeserializer() {
            return buf -> {
                if (buf.readBoolean()) {
                    return new ControllerChannelClientInfo((FriendlyByteBuf)buf);
                }
                return null;
            };
        }

        public BiConsumer<FriendlyByteBuf, ControllerChannelClientInfo> getSerializer() {
            return (buf, info) -> {
                if (info == null) {
                    buf.writeBoolean(false);
                } else {
                    buf.writeBoolean(true);
                    info.writeToBuf((FriendlyByteBuf)buf);
                }
            };
        }
    }
}

