/*
 * Decompiled with CFR 0.152.
 */
package commoble.hyperbox.dimension;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import commoble.hyperbox.Hyperbox;
import commoble.hyperbox.blocks.ApertureBlock;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.Structure;

public class HyperboxChunkGenerator
extends ChunkGenerator {
    public static final ChunkPos CHUNKPOS = new ChunkPos(0, 0);
    public static final long CHUNKID = CHUNKPOS.m_45588_();
    public static final BlockPos CORNER = CHUNKPOS.m_45615_();
    public static final BlockPos CENTER = CORNER.m_7918_(7, 7, 7);
    public static final BlockPos MIN_SPAWN_CORNER = CORNER.m_7918_(1, 1, 1);
    public static final BlockPos MAX_SPAWN_CORNER = CORNER.m_7918_(13, 12, 13);
    private final Holder<Biome> biome;

    public Holder<Biome> biome() {
        return this.biome;
    }

    public static Codec<HyperboxChunkGenerator> makeCodec() {
        return Biome.f_47431_.fieldOf("biome").xmap(HyperboxChunkGenerator::new, HyperboxChunkGenerator::biome).codec();
    }

    public int getHeight() {
        return 15;
    }

    public HyperboxChunkGenerator(MinecraftServer server) {
        this((Holder<Biome>)server.m_206579_().m_175515_(Registries.f_256952_).m_246971_(Hyperbox.BIOME_KEY));
    }

    public HyperboxChunkGenerator(Holder<Biome> biome) {
        super((BiomeSource)new FixedBiomeSource(biome));
        this.biome = biome;
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return (Codec)Hyperbox.INSTANCE.hyperboxChunkGeneratorCodec.get();
    }

    public void m_213679_(WorldGenRegion world, long seed, RandomState random, BiomeManager biomeManager, StructureManager structureManager, ChunkAccess chunkAccess, GenerationStep.Carving carvingStep) {
    }

    public void m_214194_(WorldGenRegion worldGenRegion, StructureManager structureFeatureManager, RandomState random, ChunkAccess chunk) {
        ChunkPos chunkPos = chunk.m_7697_();
        if (chunkPos.equals((Object)CHUNKPOS)) {
            BlockState wallState = Blocks.f_50752_.m_49966_();
            BlockPos.MutableBlockPos mutaPos = new BlockPos.MutableBlockPos();
            mutaPos.m_122190_((Vec3i)CORNER);
            int maxHorizontal = 14;
            int ceilingY = this.getHeight() - 1;
            for (int xOff = 0; xOff <= maxHorizontal; ++xOff) {
                int worldX = CORNER.m_123341_() + xOff;
                for (int zOff = 0; zOff <= maxHorizontal; ++zOff) {
                    int worldZ = CORNER.m_123343_() + zOff;
                    if (xOff == 0 || xOff == maxHorizontal || zOff == 0 || zOff == maxHorizontal) {
                        for (int y = 1; y < ceilingY; ++y) {
                            mutaPos.m_122178_(worldX, y, worldZ);
                            chunk.m_6978_((BlockPos)mutaPos, wallState, false);
                        }
                    }
                    mutaPos.m_122178_(worldX, 0, worldZ);
                    chunk.m_6978_((BlockPos)mutaPos, wallState, false);
                    mutaPos.m_122178_(worldX, ceilingY, worldZ);
                    chunk.m_6978_((BlockPos)mutaPos, wallState, false);
                }
            }
            BlockState aperture = ((ApertureBlock)((Object)Hyperbox.INSTANCE.apertureBlock.get())).m_49966_();
            Consumer<Direction> apertureSetter = dir -> chunk.m_6978_((BlockPos)mutaPos, (BlockState)aperture.m_61124_((Property)ApertureBlock.FACING, (Comparable)dir), false);
            int centerX = CENTER.m_123341_();
            int centerY = CENTER.m_123342_();
            int centerZ = CENTER.m_123343_();
            int west = centerX - 7;
            int east = centerX + 7;
            int down = centerY - 7;
            int up = centerY + 7;
            int north = centerZ - 7;
            int south = centerZ + 7;
            mutaPos.m_122178_(centerX, up, centerZ);
            apertureSetter.accept(Direction.DOWN);
            mutaPos.m_122178_(centerX, down, centerZ);
            apertureSetter.accept(Direction.UP);
            mutaPos.m_122178_(centerX, centerY, south);
            apertureSetter.accept(Direction.NORTH);
            mutaPos.m_122178_(centerX, centerY, north);
            apertureSetter.accept(Direction.SOUTH);
            mutaPos.m_122178_(east, centerY, centerZ);
            apertureSetter.accept(Direction.WEST);
            mutaPos.m_122178_(west, centerY, centerZ);
            apertureSetter.accept(Direction.EAST);
        }
    }

    public void m_6929_(WorldGenRegion region) {
    }

    public int m_6331_() {
        return 16;
    }

    public CompletableFuture<ChunkAccess> m_213974_(Executor executor, Blender blender, RandomState random, StructureManager structures, ChunkAccess chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    public int m_6337_() {
        return 0;
    }

    public int m_142062_() {
        return 0;
    }

    public int m_214096_(int x, int z, Heightmap.Types heightmapType, LevelHeightAccessor level, RandomState random) {
        return 0;
    }

    public NoiseColumn m_214184_(int x, int z, LevelHeightAccessor level, RandomState random) {
        return new NoiseColumn(0, new BlockState[0]);
    }

    public void m_213600_(List<String> stringsToRender, RandomState random, BlockPos pos) {
    }

    @Nullable
    public Pair<BlockPos, Holder<Structure>> m_223037_(ServerLevel level, HolderSet<Structure> structures, BlockPos pos, int range, boolean skipKnownStructures) {
        return null;
    }

    public void m_213609_(WorldGenLevel world, ChunkAccess chunkAccess, StructureManager structures) {
    }

    public int m_142051_(LevelHeightAccessor level) {
        return 1;
    }

    public void m_223076_(WorldGenLevel world, StructureManager structures, ChunkAccess chunk) {
    }
}

