/*
 * Decompiled with CFR 0.152.
 */
package commoble.hyperbox.blocks;

import commoble.hyperbox.Hyperbox;
import commoble.hyperbox.RotationHelper;
import commoble.hyperbox.blocks.ApertureBlockEntity;
import commoble.hyperbox.blocks.HyperboxBlockEntity;
import commoble.hyperbox.blocks.HyperboxBlockItem;
import commoble.hyperbox.dimension.HyperboxChunkGenerator;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class HyperboxBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty ATTACHMENT_DIRECTION = BlockStateProperties.f_61372_;
    public static final IntegerProperty ROTATION = IntegerProperty.m_61631_((String)"rotation", (int)0, (int)3);

    public HyperboxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ATTACHMENT_DIRECTION, (Comparable)Direction.DOWN)).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ATTACHMENT_DIRECTION, ROTATION});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)Hyperbox.INSTANCE.hyperboxBlockEntityType.get()).m_155264_(pos, state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState defaultState = this.m_49966_();
        BlockPos placePos = context.m_8083_();
        Direction faceOfAdjacentBlock = context.m_43719_();
        Direction directionTowardAdjacentBlock = faceOfAdjacentBlock.m_122424_();
        Vec3 relativeHitVec = context.m_43720_().m_82546_(Vec3.m_82528_((Vec3i)placePos));
        return HyperboxBlock.getStateForPlacement(defaultState, placePos, directionTowardAdjacentBlock, relativeHitVec);
    }

    public static BlockState getStateForPlacement(BlockState defaultState, BlockPos placePos, Direction directionTowardAdjacentBlock, Vec3 relativeHitVec) {
        Direction outputDirection = RotationHelper.getOutputDirectionFromRelativeHitVec(relativeHitVec, directionTowardAdjacentBlock);
        int rotationIndex = RotationHelper.getRotationIndexForDirection(directionTowardAdjacentBlock, outputDirection);
        if (defaultState.m_61138_((Property)ATTACHMENT_DIRECTION) && defaultState.m_61138_((Property)ROTATION)) {
            return (BlockState)((BlockState)defaultState.m_61124_((Property)ATTACHMENT_DIRECTION, (Comparable)directionTowardAdjacentBlock)).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(rotationIndex));
        }
        return defaultState;
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof HyperboxBlockEntity) {
                HyperboxBlockEntity hyperbox = (HyperboxBlockEntity)blockEntity;
                hyperbox.teleportPlayerOrOpenMenu(serverPlayer, hit.m_82434_());
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof HyperboxBlockEntity) {
            HyperboxBlockEntity hyperbox = (HyperboxBlockEntity)blockEntity;
            Item item = stack.m_41720_();
            if (item instanceof HyperboxBlockItem) {
                HyperboxBlockItem hyperboxItem = (HyperboxBlockItem)item;
                hyperbox.setColor(hyperboxItem.m_41121_(stack));
            }
            if (!level.f_46443_) {
                if (stack.m_41788_()) {
                    hyperbox.setName(stack.m_41786_());
                }
                if (hyperbox.getLevelKey().isPresent()) {
                    hyperbox.updateDimensionAfterPlacingBlock();
                }
            }
        }
    }

    @Deprecated
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, level, pos, newState, isMoving);
        HyperboxBlock.notifyNeighborsOfStrongSignalChange(state, level, pos);
    }

    public BlockPos getPosAdjacentToAperture(BlockState state, Direction worldSpaceFace) {
        Direction originalFace = this.getOriginalFace(state, worldSpaceFace);
        return HyperboxChunkGenerator.CENTER.m_5484_(originalFace, 6);
    }

    @Deprecated
    public boolean m_7899_(BlockState state) {
        return true;
    }

    @Deprecated
    public int m_6378_(BlockState blockState, BlockGetter level, BlockPos pos, Direction sideOfAdjacentBlock) {
        int n;
        Direction originalFace = this.getOriginalFace(blockState, sideOfAdjacentBlock.m_122424_());
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof HyperboxBlockEntity) {
            HyperboxBlockEntity hyperbox = (HyperboxBlockEntity)blockEntity;
            n = hyperbox.getPower(false, originalFace);
        } else {
            n = 0;
        }
        return n;
    }

    @Deprecated
    public int m_6376_(BlockState blockState, BlockGetter level, BlockPos pos, Direction sideOfAdjacentBlock) {
        int n;
        Direction originalFace = this.getOriginalFace(blockState, sideOfAdjacentBlock.m_122424_());
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof HyperboxBlockEntity) {
            HyperboxBlockEntity hyperbox = (HyperboxBlockEntity)blockEntity;
            n = hyperbox.getPower(true, originalFace);
        } else {
            n = 0;
        }
        return n;
    }

    @Deprecated
    public void m_6861_(BlockState thisState, Level level, BlockPos thisPos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
        this.onNeighborUpdated(thisState, (BlockGetter)level, thisPos, level.m_8055_(fromPos), fromPos);
        super.m_6861_(thisState, level, thisPos, fromBlock, fromPos, isMoving);
    }

    public void onNeighborChange(BlockState thisState, LevelReader level, BlockPos thisPos, BlockPos neighborPos) {
        this.onNeighborUpdated(thisState, (BlockGetter)level, thisPos, level.m_8055_(neighborPos), neighborPos);
        super.onNeighborChange(thisState, level, thisPos, neighborPos);
    }

    protected void onNeighborUpdated(BlockState thisState, BlockGetter level, BlockPos thisPos, BlockState neighborState, BlockPos neighborPos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos offsetToNeighbor = neighborPos.m_121996_((Vec3i)thisPos);
            Direction directionToNeighbor = Direction.m_122378_((int)offsetToNeighbor.m_123341_(), (int)offsetToNeighbor.m_123342_(), (int)offsetToNeighbor.m_123343_());
            if (directionToNeighbor != null) {
                this.getApertureTileEntityForFace(thisState, serverLevel, thisPos, directionToNeighbor).ifPresent(te -> {
                    te.updatePower(serverLevel, neighborPos, neighborState, directionToNeighbor);
                    te.m_6596_();
                });
            }
        }
    }

    public static void notifyNeighborsOfStrongSignalChange(BlockState state, Level world, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            world.m_46672_(pos.m_121945_(direction), state.m_60734_());
        }
    }

    public Optional<ApertureBlockEntity> getApertureTileEntityForFace(BlockState thisState, ServerLevel world, BlockPos thisPos, Direction directionToNeighbor) {
        Optional<ApertureBlockEntity> optional;
        Direction originalFace = this.getOriginalFace(thisState, directionToNeighbor);
        BlockEntity blockEntity = world.m_7702_(thisPos);
        if (blockEntity instanceof HyperboxBlockEntity) {
            HyperboxBlockEntity hyperbox = (HyperboxBlockEntity)blockEntity;
            optional = hyperbox.getAperture(world.m_7654_(), originalFace);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public Direction getOriginalFace(BlockState thisState, Direction worldSpaceFace) {
        Direction downRotated = (Direction)thisState.m_61143_((Property)ATTACHMENT_DIRECTION);
        if (downRotated == worldSpaceFace) {
            return Direction.DOWN;
        }
        if (downRotated.m_122424_() == worldSpaceFace) {
            return Direction.UP;
        }
        int rotationIndex = (Integer)thisState.m_61143_((Property)ROTATION);
        Direction newNorth = RotationHelper.getOutputDirection(downRotated, rotationIndex);
        if (newNorth == worldSpaceFace) {
            return Direction.NORTH;
        }
        if (newNorth.m_122424_() == worldSpaceFace) {
            return Direction.SOUTH;
        }
        Direction newEast = RotationHelper.getInputDirection(downRotated, rotationIndex, 1);
        return newEast == worldSpaceFace ? Direction.EAST : Direction.WEST;
    }

    public Direction getCurrentFacing(BlockState thisState, Direction originalFace) {
        Direction currentDown = (Direction)thisState.m_61143_((Property)ATTACHMENT_DIRECTION);
        int rotation = (Integer)thisState.m_61143_((Property)ROTATION);
        return originalFace == Direction.DOWN ? currentDown : (originalFace == Direction.UP ? currentDown.m_122424_() : RotationHelper.getInputDirection(currentDown, rotation, RotationHelper.getRotationIndexForHorizontal(originalFace)));
    }

    public static boolean getIsNormalCube(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    @Deprecated
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        if (state.m_61138_((Property)ATTACHMENT_DIRECTION) && state.m_61138_((Property)ROTATION)) {
            Direction attachmentDirection = (Direction)state.m_61143_((Property)ATTACHMENT_DIRECTION);
            int rotationIndex = (Integer)state.m_61143_((Property)ROTATION);
            Direction newAttachmentDirection = rotation.m_55954_(attachmentDirection);
            int newRotationIndex = RotationHelper.getRotatedRotation(attachmentDirection, rotationIndex, rotation);
            return (BlockState)((BlockState)state.m_61124_((Property)ATTACHMENT_DIRECTION, (Comparable)newAttachmentDirection)).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(newRotationIndex));
        }
        return state;
    }

    @Deprecated
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (state.m_61138_((Property)ATTACHMENT_DIRECTION) && state.m_61138_((Property)ROTATION)) {
            Direction attachmentDirection = (Direction)state.m_61143_((Property)ATTACHMENT_DIRECTION);
            int rotationIndex = (Integer)state.m_61143_((Property)ROTATION);
            Direction newAttachmentDirection = mirror.m_54848_(attachmentDirection);
            int newRotationIndex = RotationHelper.getMirroredRotation(attachmentDirection, rotationIndex, mirror);
            return (BlockState)((BlockState)state.m_61124_((Property)ATTACHMENT_DIRECTION, (Comparable)newAttachmentDirection)).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(newRotationIndex));
        }
        return state;
    }
}

