/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.network.message;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.network.message.NetworkMessage;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record S2C_SendConfigDataMessage(String config, Map<String, NetworkConfigValue<?>> values) implements NetworkMessage
{
    public static final ResourceLocation IDENTIFIER = new ResourceLocation("configuration", "send_config_data");

    public S2C_SendConfigDataMessage(String config) {
        this(config, null);
    }

    private static Map<String, ConfigValue<?>> loadValuesForSynchronization(String config) {
        ConfigHolder holder = ConfigHolder.getConfig(config).orElseThrow(() -> new IllegalArgumentException("Unknown config: " + config));
        return holder.getNetworkSerializedFields();
    }

    @Override
    public ResourceLocation getPacketId() {
        return IDENTIFIER;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        Map<String, ConfigValue<?>> synchronizedFields = S2C_SendConfigDataMessage.loadValuesForSynchronization(this.config);
        buf.m_130070_(this.config);
        buf.writeInt(synchronizedFields.size());
        Configuration.LOGGER.debug("Sending {} config fields to client from config '{}'", (Object)synchronizedFields.size(), (Object)this.config);
        for (Map.Entry<String, ConfigValue<?>> entry : synchronizedFields.entrySet()) {
            String field = entry.getKey();
            ConfigValue<?> value = entry.getValue();
            buf.m_130070_(field);
            this.encodeToBuffer(value, buf);
        }
    }

    @Override
    public void handle(Player player) {
        Configuration.LOGGER.debug("Received {} config fields from server for config '{}'", (Object)this.values.size(), (Object)this.config);
        for (Map.Entry<String, NetworkConfigValue<?>> entry : this.values.entrySet()) {
            NetworkConfigValue<?> value = entry.getValue();
            value.bind();
        }
    }

    private <T> void encodeToBuffer(ConfigValue<T> value, FriendlyByteBuf buffer) {
        TypeAdapter<T> adapter = value.getAdapter();
        adapter.encodeToBuffer(value, buffer);
    }

    public static S2C_SendConfigDataMessage read(FriendlyByteBuf buffer) {
        Map<String, ConfigValue<?>> synchronizedFields;
        String config = buffer.m_130277_();
        int valuesCount = buffer.readInt();
        if (valuesCount != (synchronizedFields = S2C_SendConfigDataMessage.loadValuesForSynchronization(config)).size()) {
            throw new IllegalArgumentException("Number of synchronization fields did not match for config " + config);
        }
        LinkedHashMap values = new LinkedHashMap();
        for (int i = 0; i < valuesCount; ++i) {
            String field = buffer.m_130277_();
            ConfigValue<?> configValue = synchronizedFields.get(field);
            if (configValue == null) {
                Configuration.LOGGER.fatal("Received unknown config value {}", (Object)field);
                throw new RuntimeException("Unknown config field: " + field);
            }
            S2C_SendConfigDataMessage.saveValue(values, configValue, field, buffer);
        }
        return new S2C_SendConfigDataMessage(config, values);
    }

    private static <T> void saveValue(Map<String, NetworkConfigValue<?>> map, ConfigValue<T> value, String field, FriendlyByteBuf buffer) {
        TypeAdapter<T> adapter = value.getAdapter();
        T t = adapter.decodeFromBuffer(value, buffer);
        map.put(field, new NetworkConfigValue<T>(value, t));
    }

    private record NetworkConfigValue<T>(ConfigValue<T> configValue, T value) {
        void bind() {
            this.configValue.setFromNetwork(this.value);
        }
    }
}

