/*
 * Decompiled with CFR 0.152.
 */
package invtweaks.util;

import com.google.common.base.Equivalence;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Streams;
import invtweaks.InvTweaksMod;
import invtweaks.config.Category;
import invtweaks.config.ContOverride;
import invtweaks.config.InvTweaksConfig;
import invtweaks.config.Ruleset;
import invtweaks.util.Utils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class Sorting {
    private Sorting() {
    }

    public static void executeSort(Player player, boolean isPlayerSort, String screenClass) {
        if (player != null && InvTweaksConfig.isDebugEnabled()) {
            InvTweaksMod.LOGGER.debug("screen: " + screenClass);
        }
        if (isPlayerSort) {
            Map<String, Category> cats = InvTweaksConfig.getPlayerCats(player);
            Ruleset rules = InvTweaksConfig.getPlayerRules(player);
            IntList lockedSlots = Optional.ofNullable(rules.catToInventorySlots("/LOCKED")).map(IntArrayList::new).orElseGet(IntArrayList::new);
            lockedSlots.addAll(Optional.ofNullable(rules.catToInventorySlots("/FROZEN")).orElse((IntList)IntLists.EMPTY_LIST));
            lockedSlots.sort(null);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Sorting.playerSortServer(serverPlayer, cats, rules, lockedSlots);
            } else {
                Sorting.playerSortClient(player, cats, rules, lockedSlots);
            }
        } else {
            ContOverride override;
            boolean isSortDisabled;
            AbstractContainerMenu cont = player.f_36096_;
            if (cont != player.f_36095_ && !(isSortDisabled = Optional.ofNullable(override = InvTweaksConfig.getPlayerContOverride(player, screenClass, cont.getClass().getName())).filter(ContOverride::isSortDisabled).isPresent())) {
                List validSlots = (override != null && override.getSortRange() != null ? override.getSortRange().intStream().filter(Objects::nonNull).filter(idx -> 0 <= idx && idx < cont.f_38839_.size()).mapToObj(arg_0 -> ((NonNullList)cont.f_38839_).get(arg_0)) : cont.f_38839_.stream()).filter(slot -> !(slot.f_40218_ instanceof Inventory)).filter(slot -> slot.m_8010_(player) && (slot.m_5857_(slot.m_7993_()) || !slot.m_6657_())).collect(Collectors.toCollection(ArrayList::new));
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    Sorting.inventorySortServer(serverPlayer, validSlots);
                } else {
                    Sorting.inventorySortClient(player, validSlots);
                }
            }
        }
    }

    public static void playerSortClient(Player player, Map<String, Category> cats, Ruleset rules, IntList lockedSlots) {
        Inventory inv = player.m_150109_();
        MultiPlayerGameMode pc = Minecraft.m_91087_().f_91072_;
        Int2ObjectMap indexToSlot = (Int2ObjectMap)player.f_36096_.f_38839_.stream().filter(slot -> slot.f_40218_ instanceof Inventory).filter(slot -> 0 <= slot.getSlotIndex() && slot.getSlotIndex() < 36).collect(Collectors.toMap(Slot::getSlotIndex, Function.identity(), (u, v) -> u, Int2ObjectOpenHashMap::new));
        IntList stackIdxs = (IntList)IntStream.range(0, inv.f_35974_.size()).filter(idx -> Collections.binarySearch(lockedSlots, idx) < 0).filter(idx -> !((ItemStack)inv.f_35974_.get(idx)).m_41619_()).collect(IntArrayList::new, IntList::add, IntList::addAll);
        Map<Equivalence.Wrapper<ItemStack>, Set<Slot>> gatheredSlots = Utils.gatheredSlots(() -> stackIdxs.stream().mapToInt(v -> v).mapToObj(arg_0 -> ((Int2ObjectMap)indexToSlot).get(arg_0)).filter(Slot::m_6657_).iterator());
        ArrayList<Equivalence.Wrapper<ItemStack>> stackWs = new ArrayList<Equivalence.Wrapper<ItemStack>>(gatheredSlots.keySet());
        stackWs.sort(Comparator.comparing(Equivalence.Wrapper::get, Utils.FALLBACK_COMPARATOR));
        for (Map.Entry<String, Category> ent : cats.entrySet()) {
            IntList specificRules = rules.catToInventorySlots(ent.getKey());
            if (specificRules == null) {
                specificRules = IntLists.EMPTY_LIST;
            }
            specificRules = (IntList)specificRules.stream().filter(idx -> Collections.binarySearch(lockedSlots, idx) < 0).mapToInt(v -> v).collect(IntArrayList::new, IntList::add, IntList::addAll);
            List specificRulesSlots = specificRules.stream().map(idx -> (Slot)indexToSlot.get(idx.intValue())).collect(Collectors.toCollection(ArrayList::new));
            ListIterator<Slot> toIt = specificRulesSlots.listIterator();
            Client.processCategoryClient(player, pc, gatheredSlots, stackWs, ent.getValue(), toIt);
        }
        List fallbackList = Stream.concat(Streams.stream(Optional.ofNullable(rules.catToInventorySlots("/OTHER"))).flatMap(Collection::stream), rules.fallbackInventoryRules().stream()).mapToInt(v -> v).filter(idx -> Collections.binarySearch(lockedSlots, idx) < 0).distinct().mapToObj(arg_0 -> ((Int2ObjectMap)indexToSlot).get(arg_0)).collect(Collectors.toCollection(ArrayList::new));
        Client.processCategoryClient(player, pc, gatheredSlots, stackWs, null, fallbackList.listIterator());
    }

    public static void playerSortServer(ServerPlayer player, Map<String, Category> cats, Ruleset rules, IntList lockedSlots) {
        Inventory inv = player.m_150109_();
        List<ItemStack> stacks = Utils.condensed(() -> IntStream.range(0, inv.f_35974_.size()).filter(idx -> Collections.binarySearch(lockedSlots, idx) < 0).mapToObj(arg_0 -> ((NonNullList)inv.f_35974_).get(arg_0)).filter(st -> !st.m_41619_()).iterator());
        stacks.sort(Utils.FALLBACK_COMPARATOR);
        stacks = new LinkedList<ItemStack>(stacks);
        for (int i = 0; i < inv.f_35974_.size(); ++i) {
            if (Collections.binarySearch(lockedSlots, i) >= 0) continue;
            inv.f_35974_.set(i, (Object)ItemStack.f_41583_);
        }
        for (Map.Entry<String, Category> ent : cats.entrySet()) {
            IntList specificRules = rules.catToInventorySlots(ent.getKey());
            if (specificRules == null) {
                specificRules = IntLists.EMPTY_LIST;
            }
            specificRules = (IntList)specificRules.stream().filter(idx -> Collections.binarySearch(lockedSlots, idx) < 0).mapToInt(v -> v).collect(IntArrayList::new, IntList::add, IntList::addAll);
            ArrayList<ItemStack> curStacks = new ArrayList<ItemStack>();
            Iterator<ItemStack> it = stacks.iterator();
            while (it.hasNext() && curStacks.size() < specificRules.size()) {
                ItemStack st = it.next();
                if (ent.getValue().checkStack(st) < 0) continue;
                curStacks.add(st);
                it.remove();
            }
            curStacks.sort(Comparator.comparingInt(s -> ((Category)cats.get(ent.getKey())).checkStack((ItemStack)s)));
            Streams.zip((Stream)specificRules.stream(), curStacks.stream(), Pair::of).forEach(pr -> inv.f_35974_.set(((Integer)pr.getKey()).intValue(), (Object)((ItemStack)pr.getValue())));
        }
        PrimitiveIterator.OfInt fallbackIt = Stream.concat(Optional.ofNullable(rules.catToInventorySlots("/OTHER")).stream().flatMap(Collection::stream), rules.fallbackInventoryRules().stream()).mapToInt(v -> v).iterator();
        while (fallbackIt.hasNext()) {
            int idx2 = fallbackIt.nextInt();
            if (Collections.binarySearch(lockedSlots, idx2) >= 0) continue;
            if (stacks.isEmpty()) break;
            if (!((ItemStack)inv.f_35974_.get(idx2)).m_41619_()) continue;
            inv.f_35974_.set(idx2, (Object)stacks.remove(0));
        }
    }

    public static void inventorySortClient(Player player, List<Slot> validSlots) {
        MultiPlayerGameMode pc = Minecraft.m_91087_().f_91072_;
        Map<Equivalence.Wrapper<ItemStack>, Set<Slot>> gatheredSlots = Utils.gatheredSlots(() -> validSlots.stream().filter(Slot::m_6657_).iterator());
        ArrayList<Equivalence.Wrapper<ItemStack>> stackWs = new ArrayList<Equivalence.Wrapper<ItemStack>>(gatheredSlots.keySet());
        stackWs.sort(Comparator.comparing(Equivalence.Wrapper::get, Utils.FALLBACK_COMPARATOR));
        ListIterator<Slot> toIt = validSlots.listIterator();
        for (Equivalence.Wrapper wrapper : stackWs) {
            HashBiMap displaced = HashBiMap.create();
            Client.clientPushToSlots(player, pc, gatheredSlots.get(wrapper).iterator(), toIt, (BiMap<Slot, Slot>)displaced);
            for (Map.Entry displacedPair : displaced.entrySet()) {
                Set<Slot> toModify = gatheredSlots.get(Utils.STACKABLE.wrap((Object)((Slot)displacedPair.getValue()).m_7993_()));
                toModify.remove(displacedPair.getKey());
                toModify.add((Slot)displacedPair.getValue());
            }
        }
    }

    public static void inventorySortServer(ServerPlayer serverPlayer, List<Slot> validSlots) {
        Slot cur;
        if (!validSlots.iterator().hasNext()) {
            return;
        }
        List<ItemStack> stacks = Utils.condensed(() -> validSlots.stream().map(Slot::m_7993_).filter(st -> !st.m_41619_()).iterator());
        stacks.sort(Utils.FALLBACK_COMPARATOR);
        Iterator<Slot> slotIt = validSlots.iterator();
        for (ItemStack stack : stacks) {
            cur = null;
            while (slotIt.hasNext() && !(cur = slotIt.next()).m_5857_(stack)) {
            }
            if (cur != null && cur.m_5857_(stack)) continue;
            return;
        }
        validSlots.forEach(slot -> slot.m_5852_(ItemStack.f_41583_));
        slotIt = validSlots.iterator();
        for (ItemStack stack : stacks) {
            cur = null;
            while (slotIt.hasNext() && !(cur = slotIt.next()).m_5857_(stack)) {
            }
            assert (cur != null);
            cur.m_5852_(stack);
        }
    }

    static class Client {
        private Client() {
        }

        static void processCategoryClient(Player player, MultiPlayerGameMode pc, Map<Equivalence.Wrapper<ItemStack>, Set<Slot>> gatheredSlots, List<Equivalence.Wrapper<ItemStack>> stackWs, Category cat, ListIterator<Slot> toIt) {
            ArrayList<Equivalence.Wrapper<ItemStack>> subStackWs = cat == null ? new ArrayList<Equivalence.Wrapper<ItemStack>>(stackWs) : (List)stackWs.stream().filter(stackW -> cat.checkStack((ItemStack)stackW.get()) >= 0).sorted(Comparator.comparingInt(stackW -> cat.checkStack((ItemStack)stackW.get()))).collect(Collectors.toCollection(ArrayList::new));
            for (Equivalence.Wrapper wrapper : subStackWs) {
                if (cat != null && cat.checkStack((ItemStack)wrapper.get()) < 0) continue;
                HashBiMap displaced = HashBiMap.create();
                ListIterator fromIt = (ListIterator)gatheredSlots.get(wrapper).iterator();
                boolean fullInserted = Client.clientPushToSlots(player, pc, fromIt, toIt, (BiMap<Slot, Slot>)displaced);
                for (Map.Entry displacedPair : displaced.entrySet()) {
                    Equivalence.Wrapper displacedW = Utils.STACKABLE.wrap((Object)((Slot)displacedPair.getValue()).m_7993_());
                    Set<Slot> toModify = gatheredSlots.get(displacedW);
                    toModify.remove(displacedPair.getKey());
                    toModify.add((Slot)displacedPair.getValue());
                }
            }
            stackWs.removeIf(sw -> ((Set)gatheredSlots.get(sw)).isEmpty());
            gatheredSlots.values().removeIf(Set::isEmpty);
        }

        static boolean clientPushToSlots(Player player, MultiPlayerGameMode playerController, Iterator<Slot> OriginIter, ListIterator<Slot> destinationIter, BiMap<Slot, Slot> displaced) {
            if (!destinationIter.hasNext()) {
                return true;
            }
            boolean completedCurrentItemSwap = true;
            while (OriginIter.hasNext()) {
                completedCurrentItemSwap = false;
                Slot originSlot = OriginIter.next();
                playerController.m_171799_(player.f_36096_.f_38840_, originSlot.f_40219_, 0, ClickType.PICKUP, player);
                Slot destinationSlot = null;
                while (destinationIter.hasNext()) {
                    if (destinationIter.hasPrevious() && ((destinationSlot = destinationIter.previous()).m_7993_().m_41613_() == Math.min(destinationSlot.m_6641_(), destinationSlot.m_7993_().m_41741_()) || !Utils.STACKABLE.equivalent((Object)destinationSlot.m_7993_(), (Object)player.f_36096_.m_142621_()))) {
                        destinationIter.next();
                    }
                    destinationSlot = destinationIter.next();
                    playerController.m_171799_(player.f_36096_.f_38840_, destinationSlot.f_40219_, 0, ClickType.PICKUP, player);
                    if (player.f_36096_.m_142621_().m_41619_()) {
                        completedCurrentItemSwap = true;
                        break;
                    }
                    if (Utils.STACKABLE.equivalent((Object)destinationSlot.m_7993_(), (Object)player.f_36096_.m_142621_())) continue;
                    playerController.m_171799_(player.f_36096_.f_38840_, originSlot.f_40219_, 0, ClickType.PICKUP, player);
                    if (!originSlot.m_6657_() || ItemHandlerHelper.canItemStacksStack((ItemStack)originSlot.m_7993_(), (ItemStack)destinationSlot.m_7993_())) continue;
                    completedCurrentItemSwap = true;
                    displaced.put((Object)destinationSlot, (Object)originSlot);
                    break;
                }
                if (destinationIter.hasNext() || !Optional.ofNullable(destinationSlot).filter(s -> s.m_7993_().m_41613_() >= Math.min(s.m_6641_(), s.m_7993_().m_41741_())).isPresent()) continue;
                break;
            }
            return completedCurrentItemSwap;
        }
    }
}

