/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.xmod.gtceu;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import com.glodblock.github.appflux.common.me.key.FluxKey;
import com.glodblock.github.appflux.common.me.key.type.EnergyType;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.compat.FeCompat;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public record GTEUPower(IStorageService storage, IActionSource source, Supplier<CompoundTag> data) implements IEnergyContainer
{
    private static final String TAG_NAME = "gt_buff";

    public static IEnergyContainer of(@Nullable IStorageService storage, IActionSource source, Supplier<CompoundTag> data) {
        if (storage != null) {
            return new GTEUPower(storage, source, data);
        }
        return IEnergyContainer.DEFAULT;
    }

    public long acceptEnergyFromNetwork(Direction side, long voltage, long amperage) {
        long buffed = this.data.get().m_128454_(TAG_NAME);
        if (buffed != 0L) {
            long added = this.storage.getInventory().insert((AEKey)FluxKey.of(EnergyType.FE), buffed, Actionable.MODULATE, this.source);
            if (added < buffed) {
                this.data.get().m_128356_(TAG_NAME, buffed - added);
                return 0L;
            }
            this.data.get().m_128473_(TAG_NAME);
        }
        long packetSize = FeCompat.toFeLong((long)voltage, (int)FeCompat.ratio((boolean)false));
        long toAdd = packetSize * amperage;
        long canAdd = this.storage.getInventory().insert((AEKey)FluxKey.of(EnergyType.FE), toAdd, Actionable.SIMULATE, this.source);
        if (canAdd > 0L) {
            long added;
            long ampUsed = canAdd / packetSize;
            if (ampUsed * packetSize < canAdd) {
                ++ampUsed;
            }
            if ((buffed = (toAdd = ampUsed * packetSize) - (added = this.storage.getInventory().insert((AEKey)FluxKey.of(EnergyType.FE), toAdd, Actionable.MODULATE, this.source))) != 0L) {
                this.data.get().m_128356_(TAG_NAME, buffed);
            }
            return ampUsed;
        }
        return 0L;
    }

    public boolean inputsEnergy(Direction side) {
        return true;
    }

    public long changeEnergy(long delta) {
        if ((delta = FeCompat.toFeLong((long)delta, (int)FeCompat.ratio((boolean)false))) == 0L) {
            return 0L;
        }
        if (delta > 0L) {
            return this.storage.getInventory().insert((AEKey)FluxKey.of(EnergyType.FE), delta, Actionable.MODULATE, this.source);
        }
        return this.storage.getInventory().extract((AEKey)FluxKey.of(EnergyType.FE), -delta, Actionable.MODULATE, this.source);
    }

    public long getEnergyStored() {
        return FeCompat.toEu((long)this.storage.getCachedInventory().get((AEKey)FluxKey.of(EnergyType.FE)), (int)FeCompat.ratio((boolean)false));
    }

    public long getEnergyCapacity() {
        long space = this.storage.getInventory().insert((AEKey)FluxKey.of(EnergyType.FE), 0x7FFFFFFFFFFFFFFEL, Actionable.SIMULATE, this.source);
        return FeCompat.toEu((long)(space + this.getEnergyStored()), (int)FeCompat.ratio((boolean)false));
    }

    public long getInputAmperage() {
        return 2L;
    }

    public long getInputVoltage() {
        return Integer.MAX_VALUE;
    }

    public boolean isOneProbeHidden() {
        return true;
    }
}

