/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.common.items;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKeyType;
import appeng.api.storage.ITerminalHost;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.upgrades.Upgrades;
import appeng.items.contents.PortableCellMenuHost;
import appeng.items.tools.powered.AbstractPortableCell;
import appeng.menu.me.common.MEStorageMenu;
import com.glodblock.github.appflux.AppFlux;
import com.glodblock.github.appflux.api.IFluxCell;
import com.glodblock.github.appflux.common.AFContainers;
import com.glodblock.github.appflux.common.AFItemAndBlock;
import com.glodblock.github.appflux.common.me.cell.FECellHandler;
import com.glodblock.github.appflux.common.me.cell.FluxCellInventory;
import com.glodblock.github.appflux.common.me.key.FluxKey;
import com.glodblock.github.appflux.common.me.key.type.EnergyType;
import com.glodblock.github.appflux.common.me.key.type.FluxKeyType;
import com.glodblock.github.appflux.util.AFUtil;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class ItemPortableFECell
extends AbstractPortableCell
implements IFluxCell {
    private final long totalBytes;
    private final double idleDrain;

    public ItemPortableFECell(int quartKilobytes, double idleDrain, int defaultColor) {
        super(AFContainers.PORTABLE_FE_CELL_TYPE, new Item.Properties().m_41487_(1), defaultColor);
        this.totalBytes = (long)quartKilobytes * 256L;
        this.idleDrain = idleDrain;
    }

    public IUpgradeInventory getUpgrades(ItemStack is) {
        return UpgradeInventories.forItem((ItemStack)is, (int)4);
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        if (!level.m_5776_() && entity instanceof Player) {
            Player player = (Player)entity;
            boolean induct = this.getUpgrades(stack).isInstalled((ItemLike)AFItemAndBlock.INDUCTION_CARD);
            FluxCellInventory storedInv = this.getUsingStorage(player, stack);
            if (induct && storedInv != null) {
                Inventory inv = player.m_150109_();
                for (int slot = 0; slot < inv.m_6643_(); ++slot) {
                    if (storedInv.getStoredEnergy() <= 0L) {
                        return;
                    }
                    IEnergyStorage cap = (IEnergyStorage)AFUtil.findCapability(inv.m_8020_(slot), ForgeCapabilities.ENERGY);
                    if (cap == null || !cap.canReceive()) continue;
                    int toAdd = AFUtil.clampLong(storedInv.getStoredEnergy());
                    int added = cap.receiveEnergy(toAdd, false);
                    storedInv.extract(FluxKey.of(EnergyType.FE), added, Actionable.MODULATE, IActionSource.ofPlayer((Player)player));
                }
            }
        }
    }

    private FluxCellInventory getUsingStorage(Player player, ItemStack stack) {
        PortableCellMenuHost cell;
        MEStorageMenu container;
        ITerminalHost iTerminalHost;
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof MEStorageMenu && (iTerminalHost = (container = (MEStorageMenu)abstractContainerMenu).getHost()) instanceof PortableCellMenuHost && (cell = (PortableCellMenuHost)iTerminalHost).getItemStack() == stack) {
            return (FluxCellInventory)cell.getInventory();
        }
        return FECellHandler.HANDLER.getCellInventory(stack, null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> lines, TooltipFlag advancedTooltips) {
        super.m_7373_(stack, level, lines, advancedTooltips);
        this.addCellInformationToTooltip(stack, lines);
    }

    public ResourceLocation getRecipeId() {
        return AppFlux.id("tools/" + Objects.requireNonNull(this.getRegistryName()).m_135815_());
    }

    public double getChargeRate(ItemStack stack) {
        return 80.0 + 80.0 * (double)Upgrades.getEnergyCardMultiplier((IUpgradeInventory)this.getUpgrades(stack));
    }

    @Override
    public AEKeyType getKeyType() {
        return FluxKeyType.TYPE;
    }

    @Override
    public EnergyType getEnergyType() {
        return EnergyType.FE;
    }

    @Override
    public long getBytes(ItemStack cellItem) {
        return this.totalBytes;
    }

    @Override
    public double getIdleDrain() {
        return this.idleDrain;
    }

    @Override
    public void addCellInformationToTooltip(ItemStack is, List<Component> lines) {
        Preconditions.checkArgument((is.m_41720_() == this ? 1 : 0) != 0);
        FECellHandler.HANDLER.addCellInformationToTooltip(is, lines);
    }

    @Override
    public Optional<TooltipComponent> getCellTooltipImage(ItemStack is) {
        return FECellHandler.HANDLER.getTooltipImage(is);
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack stack) {
        return this.getCellTooltipImage(stack);
    }
}

