/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.common.fluid;

import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import earth.terrarium.botarium.forge.fluid.PlatformBlockFluidHandler;
import earth.terrarium.botarium.forge.fluid.PlatformFluidItemHandler;
import earth.terrarium.botarium.util.Updatable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class FluidApi {
    private static final Map<Supplier<BlockEntityType<?>>, BlockFluidGetter<?>> BLOCK_ENTITY_LOOKUP_MAP = new HashMap();
    private static final Map<Supplier<Block>, BlockFluidGetter<?>> BLOCK_LOOKUP_MAP = new HashMap();
    private static final Map<Supplier<Item>, ItemFluidGetter<?>> ITEM_LOOKUP_MAP = new HashMap();
    public static final Map<BlockEntityType<?>, BlockFluidGetter<?>> FINALIZED_BLOCK_ENTITY_LOOKUP_MAP = new HashMap();
    public static final Map<Block, BlockFluidGetter<?>> FINALIZED_BLOCK_LOOKUP_MAP = new HashMap();
    public static boolean blocksFinalized = false;
    public static final Map<Item, ItemFluidGetter<?>> FINALIZED_ITEM_LOOKUP_MAP = new HashMap();
    public static boolean itemsFinalized = false;

    public static void finalizeBlockRegistration() {
        if (!blocksFinalized) {
            System.out.println("Finalizing fluid block registration");
            for (Map.Entry<Supplier<BlockEntityType<?>>, BlockFluidGetter<?>> entry : BLOCK_ENTITY_LOOKUP_MAP.entrySet()) {
                FINALIZED_BLOCK_ENTITY_LOOKUP_MAP.put(entry.getKey().get(), entry.getValue());
            }
            for (Map.Entry<Supplier<BlockEntityType<?>>, BlockFluidGetter<?>> entry : BLOCK_LOOKUP_MAP.entrySet()) {
                FINALIZED_BLOCK_LOOKUP_MAP.put((Block)entry.getKey().get(), entry.getValue());
            }
            blocksFinalized = true;
        }
    }

    public static void finalizeItemRegistration() {
        if (!itemsFinalized) {
            System.out.println("Finalizing fluid item registration");
            for (Map.Entry<Supplier<Item>, ItemFluidGetter<?>> entry : ITEM_LOOKUP_MAP.entrySet()) {
                FINALIZED_ITEM_LOOKUP_MAP.put(entry.getKey().get(), entry.getValue());
            }
            itemsFinalized = true;
        }
    }

    public static void registerFluidBlockEntity(Supplier<BlockEntityType<?>> block, BlockFluidGetter<?> getter) {
        BLOCK_ENTITY_LOOKUP_MAP.put(block, getter);
    }

    @SafeVarargs
    public static void registerFluidBlockEntity(BlockFluidGetter<?> getter, Supplier<BlockEntityType<?>> ... blocks) {
        for (Supplier<BlockEntityType<?>> block : blocks) {
            BLOCK_ENTITY_LOOKUP_MAP.put(block, getter);
        }
    }

    public static void registerFluidBlock(Supplier<Block> block, BlockFluidGetter<?> getter) {
        BLOCK_LOOKUP_MAP.put(block, getter);
    }

    @SafeVarargs
    public static void registerFluidBlock(BlockFluidGetter<?> getter, Supplier<Block> ... blocks) {
        for (Supplier<Block> block : blocks) {
            BLOCK_LOOKUP_MAP.put(block, getter);
        }
    }

    public static void registerFluidItem(Supplier<Item> item, ItemFluidGetter<?> getter) {
        ITEM_LOOKUP_MAP.put(item, getter);
    }

    @SafeVarargs
    public static void registerFluidItem(ItemFluidGetter<?> getter, Supplier<Item> ... items) {
        for (Supplier<Item> item : items) {
            ITEM_LOOKUP_MAP.put(item, getter);
        }
    }

    public static ItemFluidContainer getItemFluidContainer(ItemStackHolder stack) {
        return FluidApi.isFluidContainingItem(stack.getStack()) ? new PlatformFluidItemHandler(stack) : null;
    }

    public static FluidContainer getBlockFluidContainer(BlockEntity entity, @Nullable Direction direction) {
        LazyOptional capability = entity.getCapability(ForgeCapabilities.FLUID_HANDLER, direction);
        return capability.isPresent() ? new PlatformBlockFluidHandler((IFluidHandler)capability.orElseThrow(IllegalArgumentException::new)) : null;
    }

    public static boolean isFluidContainingBlock(BlockEntity entity, @Nullable Direction direction) {
        return entity.getCapability(ForgeCapabilities.FLUID_HANDLER, direction).isPresent();
    }

    public static boolean isFluidContainingItem(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
    }

    public static long moveFluid(FluidContainer from, FluidContainer to, FluidHolder amount, boolean simulate) {
        FluidHolder extracted = from.extractFluid(amount, true);
        long inserted = to.insertFluid(extracted, true);
        FluidHolder toInsert = FluidHolder.of(amount.getFluid(), inserted, amount.getCompound());
        FluidHolder simulatedExtraction = from.extractFluid(toInsert, true);
        if (!simulate && inserted > 0L && simulatedExtraction.getFluidAmount() == inserted) {
            from.extractFluid(toInsert, false);
            to.insertFluid(toInsert, false);
        }
        return Math.max(0L, inserted);
    }

    public static long moveFluid(ItemStackHolder from, ItemStackHolder to, FluidHolder fluidHolder, boolean simulate) {
        if (!FluidApi.isFluidContainingItem(from.getStack()) || !FluidApi.isFluidContainingItem(to.getStack())) {
            return 0L;
        }
        ItemFluidContainer fromFluid = FluidApi.getItemFluidContainer(from);
        ItemFluidContainer toFluid = FluidApi.getItemFluidContainer(to);
        return FluidApi.moveFluid(fromFluid, toFluid, fluidHolder, simulate);
    }

    public static long moveFluid(BlockEntity from, BlockEntity to, FluidHolder fluidHolder, boolean simulate) {
        if (!FluidApi.isFluidContainingBlock(from, null) || !FluidApi.isFluidContainingBlock(to, null)) {
            return 0L;
        }
        FluidContainer fromFluid = FluidApi.getBlockFluidContainer(from, null);
        FluidContainer toFluid = FluidApi.getBlockFluidContainer(to, null);
        return FluidApi.moveFluid(fromFluid, toFluid, fluidHolder, simulate);
    }

    public static long moveFluid(Level level, BlockPos from, Direction extractDirection, BlockPos to, Direction insertDirection, FluidHolder fluidHolder, boolean simulate) {
        if (!FluidContainer.holdsFluid(level, from, extractDirection) || !FluidContainer.holdsFluid(level, to, insertDirection)) {
            return 0L;
        }
        FluidContainer fromFluid = FluidContainer.of(level, from, extractDirection);
        FluidContainer toFluid = FluidContainer.of(level, to, insertDirection);
        return FluidApi.moveFluid(fromFluid, toFluid, fluidHolder, simulate);
    }

    public static long moveFluid(BlockEntity from, Direction direction, ItemStackHolder to, FluidHolder fluidHolder, boolean simulate) {
        if (!FluidApi.isFluidContainingBlock(from, direction) || !FluidApi.isFluidContainingItem(to.getStack())) {
            return 0L;
        }
        FluidContainer fromFluid = FluidApi.getBlockFluidContainer(from, direction);
        ItemFluidContainer toFluid = FluidApi.getItemFluidContainer(to);
        return FluidApi.moveFluid(fromFluid, toFluid, fluidHolder, simulate);
    }

    public static long moveFluid(ItemStackHolder from, BlockEntity to, Direction direction, FluidHolder fluidHolder, boolean simulate) {
        if (!FluidApi.isFluidContainingItem(from.getStack()) || !FluidApi.isFluidContainingBlock(to, direction)) {
            return 0L;
        }
        ItemFluidContainer fromFluid = FluidApi.getItemFluidContainer(from);
        FluidContainer toFluid = FluidApi.getBlockFluidContainer(to, direction);
        return FluidApi.moveFluid(fromFluid, toFluid, fluidHolder, simulate);
    }

    @FunctionalInterface
    public static interface BlockFluidGetter<T extends FluidContainer & Updatable<BlockEntity>> {
        public T getFluidContainer(Level var1, BlockPos var2, BlockState var3, BlockEntity var4, Direction var5);
    }

    @FunctionalInterface
    public static interface ItemFluidGetter<T extends ItemFluidContainer & Updatable<ItemStack>> {
        public T getFluidContainer(ItemStack var1);
    }
}

