/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wct.magnet_card;

public enum MagnetMode {
    INVALID(-2),
    NO_CARD(-1),
    OFF(0),
    PICKUP_INVENTORY(1),
    PICKUP_ME(3),
    PICKUP_ME_NO_MAGNET(2);

    public static final MagnetMode DEFAULT;
    private final byte id;

    private MagnetMode(byte b) {
        this.id = b;
    }

    public byte getId() {
        return this.id;
    }

    public boolean magnet() {
        return this.id > 0 && (this.id & 1) != 0;
    }

    public boolean pickupToME() {
        return this.id > 0 && (this.id & 2) != 0;
    }

    public MagnetMode set(boolean magnet, boolean pickupToME) {
        if (this.id < 0) {
            return this;
        }
        return MagnetMode.fromByte((byte)((magnet ? 1 : 0) + (pickupToME ? 2 : 0)));
    }

    public static MagnetMode fromByte(byte b) {
        return switch (b) {
            case 1 -> PICKUP_INVENTORY;
            case 2 -> PICKUP_ME_NO_MAGNET;
            case 3 -> PICKUP_ME;
            default -> OFF;
        };
    }

    static {
        DEFAULT = OFF;
    }
}

