/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ItemMatch;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.integrateddynamics.api.advancement.criterion.ValuePredicate;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeUniquelyNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeItemStackLPElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;

public class ValueObjectTypeItemStack
extends ValueObjectTypeBase<ValueItemStack>
implements IValueTypeNamed<ValueItemStack>,
IValueTypeUniquelyNamed<ValueItemStack>,
IValueTypeNullable<ValueItemStack> {
    public ValueObjectTypeItemStack() {
        super("itemstack", ValueItemStack.class);
    }

    public static MutableComponent getItemStackDisplayNameUsSafe(ItemStack itemStack) throws NoSuchMethodException {
        return !itemStack.m_41619_() ? itemStack.m_41786_().m_6881_().m_130946_((String)(itemStack.m_41613_() > 1 ? " (" + itemStack.m_41613_() + ")" : "")) : Component.m_237113_((String)"");
    }

    public static MutableComponent getItemStackDisplayNameSafe(ItemStack itemStack) {
        try {
            return ValueObjectTypeItemStack.getItemStackDisplayNameUsSafe(itemStack);
        }
        catch (NoSuchMethodException e) {
            return Component.m_237115_((String)itemStack.m_41778_());
        }
    }

    @Override
    public ValueItemStack getDefault() {
        return ValueItemStack.of(ItemStack.f_41583_);
    }

    @Override
    public MutableComponent toCompactString(ValueItemStack value) {
        return ValueObjectTypeItemStack.getItemStackDisplayNameSafe(value.getRawValue());
    }

    @Override
    public Tag serialize(ValueItemStack value) {
        CompoundTag tag = new CompoundTag();
        ItemStack itemStack = value.getRawValue();
        if (!itemStack.m_41619_()) {
            itemStack.m_41739_(tag);
            tag.m_128405_("Count", itemStack.m_41613_());
        }
        return tag;
    }

    @Override
    public ValueItemStack deserialize(ValueDeseralizationContext valueDeseralizationContext, Tag value) {
        if (value instanceof CompoundTag) {
            CompoundTag tag = (CompoundTag)value;
            int realCount = tag.m_128451_("Count");
            tag = tag.m_6426_();
            tag.m_128344_("Count", (byte)1);
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)tag);
            if (!itemStack.m_41619_()) {
                itemStack.m_41764_(realCount);
            }
            return ValueItemStack.of(itemStack);
        }
        return ValueItemStack.of(ItemStack.f_41583_);
    }

    @Override
    public String getName(ValueItemStack a) {
        return this.toCompactString(a).getString();
    }

    @Override
    public boolean isNull(ValueItemStack a) {
        return a.getRawValue().m_41619_();
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeItemStackLPElement<ValueItemStack>(this, new ValueTypeItemStackLPElement.IItemStackToValue<ValueItemStack>(){

            @Override
            public boolean isNullable() {
                return true;
            }

            @Override
            public Component validate(ItemStack itemStack) {
                return null;
            }

            @Override
            public ValueItemStack getValue(ItemStack itemStack) {
                return ValueItemStack.of(itemStack);
            }

            @Override
            public ItemStack getValueAsItemStack(ValueItemStack value) {
                return value.getRawValue();
            }
        });
    }

    @Override
    public ValuePredicate<ValueItemStack> deserializeValuePredicate(JsonObject element, @Nullable IValue value) {
        ItemPredicate itemPredicate = null;
        if (element != null && !element.isJsonNull()) {
            itemPredicate = ItemPredicate.m_45051_((JsonElement)element);
        }
        return new ValueItemStackPredicate(this, value, itemPredicate);
    }

    @Override
    public ValueItemStack materialize(ValueItemStack value) throws EvaluationException {
        return ValueItemStack.of(value.getRawValue().m_41777_());
    }

    @Override
    public String getUniqueName(ValueItemStack value) {
        ItemStack itemStack = value.getRawValue();
        return !itemStack.m_41619_() ? ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString() : "";
    }

    public static class ValueItemStack
    extends ValueBase {
        private final ItemStack itemStack;

        private ValueItemStack(ItemStack itemStack) {
            super(ValueTypes.OBJECT_ITEMSTACK);
            this.itemStack = Objects.requireNonNull(itemStack, "Attempted to create a ValueItemStack for a null ItemStack.");
        }

        public static ValueItemStack of(ItemStack itemStack) {
            return new ValueItemStack(itemStack);
        }

        public ItemStack getRawValue() {
            return this.itemStack;
        }

        public boolean equals(Object o) {
            return o instanceof ValueItemStack && ItemMatch.areItemStacksEqual((ItemStack)((ValueItemStack)o).itemStack, (ItemStack)this.itemStack, (int)13);
        }

        public int hashCode() {
            return 37 + ItemStackHelpers.getItemStackHashCode((ItemStack)this.itemStack);
        }

        @Override
        public String toString() {
            return "ValueObjectTypeItemStack.ValueItemStack(itemStack=" + String.valueOf(this.itemStack) + ")";
        }
    }

    public static class ValueItemStackPredicate
    extends ValuePredicate<ValueItemStack> {
        @Nullable
        private final ItemPredicate itemPredicate;

        public ValueItemStackPredicate(@Nullable IValueType valueType, @Nullable IValue value, @Nullable ItemPredicate itemPredicate) {
            super(valueType, value);
            this.itemPredicate = itemPredicate;
        }

        @Override
        protected boolean testTyped(ValueItemStack value) {
            return super.testTyped(value) && (this.itemPredicate == null || this.itemPredicate.m_45049_(value.getRawValue()));
        }
    }
}

