/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block.shapes;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.capability.facadeable.FacadeableConfig;
import org.cyclops.integrateddynamics.core.block.BlockRayTraceResultComponent;
import org.cyclops.integrateddynamics.core.block.VoxelShapeComponents;
import org.cyclops.integrateddynamics.core.block.VoxelShapeComponentsFactory;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.WrenchHelpers;

public class VoxelShapeComponentsFactoryHandlerFacade
implements VoxelShapeComponentsFactory.IHandler {
    private static final VoxelShape BOUNDS = Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    private static final Component COMPONENT = new Component();

    @Override
    public Collection<VoxelShapeComponents.IComponent> createComponents(BlockState blockState, BlockGetter world, BlockPos blockPos) {
        if (CableHelpers.hasFacade(world, blockPos)) {
            return Collections.singletonList(COMPONENT);
        }
        return Collections.emptyList();
    }

    public static class Component
    implements VoxelShapeComponents.IComponent {
        @Override
        public String getStateId(BlockState blockState, BlockGetter world, BlockPos blockPos) {
            Object id = "fac";
            Optional<BlockState> optionalFacade = CableHelpers.getFacade(world, blockPos);
            if (optionalFacade.isPresent()) {
                id = (String)id + "(" + optionalFacade.get().toString() + ")";
            }
            return id;
        }

        @Override
        public VoxelShape getShape(BlockState blockState, BlockGetter world, BlockPos blockPos, CollisionContext selectionContext) {
            return BOUNDS;
        }

        @Override
        public ItemStack getCloneItemStack(Level world, BlockPos pos) {
            ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_FACADE);
            CableHelpers.getFacade((BlockGetter)world, pos).ifPresent(facade -> RegistryEntries.ITEM_FACADE.writeFacadeBlock(itemStack, (BlockState)facade));
            return itemStack;
        }

        @Override
        public boolean destroy(Level world, BlockPos pos, Player player, boolean saveState) {
            if (!world.m_5776_()) {
                BlockEntityHelpers.getCapability((BlockGetter)world, (BlockPos)pos, FacadeableConfig.CAPABILITY).ifPresent(facadeable -> {
                    BlockState blockState = facadeable.getFacade();
                    ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_FACADE);
                    RegistryEntries.ITEM_FACADE.writeFacadeBlock(itemStack, blockState);
                    facadeable.setFacade(null);
                    if (!player.m_7500_()) {
                        ItemStackHelpers.spawnItemStackToPlayer((Level)world, (BlockPos)pos, (ItemStack)itemStack, (Player)player);
                    }
                });
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        public BakedModel getBreakingBaseModel(Level world, BlockPos pos) {
            return CableHelpers.getFacade((BlockGetter)world, pos).map(RenderHelpers::getBakedModel).orElse(null);
        }

        @Override
        public InteractionResult onBlockActivated(BlockState state, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockRayTraceResultComponent hit) {
            ItemStack heldItem = player.m_21120_(hand);
            if (WrenchHelpers.isWrench(player, heldItem, world, blockPos, hit.m_82434_()) && player.m_36341_()) {
                if (!world.m_5776_()) {
                    this.destroy(world, blockPos, player, true);
                    world.m_46672_(blockPos, state.m_60734_());
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }

        @Override
        @Nullable
        public Direction getRaytraceDirection() {
            return null;
        }

        @Override
        public boolean isRaytraceLastForFace() {
            return true;
        }
    }
}

