/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemylib.api.storage;

import com.smashingmods.alchemylib.api.storage.ProcessingSlotHandler;
import com.smashingmods.alchemylib.api.storage.SideMode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class SidedProcessingSlotWrapper {
    public static final int LEGACY_SIDES_CONFIGURATION = SideMode.PULL.ordinal() << Direction.UP.ordinal() * 2 | SideMode.PULL.ordinal() << Direction.WEST.ordinal() * 2 | SideMode.PUSH.ordinal() << Direction.DOWN.ordinal() * 2 | SideMode.PUSH.ordinal() << Direction.EAST.ordinal() * 2;
    private final ProcessingSlotHandler inputHandler;
    private final ProcessingSlotHandler outputHandler;
    private final SideMode[] sideModes = new SideMode[7];
    private final LazyOptional<IItemHandler>[] views = new LazyOptional[7];

    public SidedProcessingSlotWrapper(ProcessingSlotHandler input, ProcessingSlotHandler output) {
        for (int i = 0; i < 7; ++i) {
            this.sideModes[i] = SideMode.ENABLED;
        }
        this.inputHandler = input;
        this.outputHandler = output;
    }

    public IItemHandler getView(@Nullable Direction side) {
        return (IItemHandler)this.getViewLazily(side).orElse(null);
    }

    public LazyOptional<IItemHandler> getViewLazily(@Nullable Direction side) {
        LazyOptional view = this.views[side == null ? 6 : side.ordinal()];
        if (view == null) {
            view = LazyOptional.of(() -> new SidedItemHandlerView(side));
            this.views[side == null ? 6 : side.ordinal()] = view;
        }
        return view;
    }

    public void setSideMode(@Nullable Direction side, SideMode mode) {
        this.sideModes[side == null ? 6 : side.ordinal()] = mode;
    }

    public SideMode getSideMode(@Nullable Direction side) {
        return this.sideModes[side == null ? 6 : side.ordinal()];
    }

    public ProcessingSlotHandler getInputHandler() {
        return this.inputHandler;
    }

    public ProcessingSlotHandler getOutputHandler() {
        return this.outputHandler;
    }

    public void invalidate() {
        for (LazyOptional<IItemHandler> view : this.views) {
            if (view == null) continue;
            view.invalidate();
        }
    }

    public short sideModesToShort() {
        int value = 0;
        for (int i = 0; i < this.sideModes.length; ++i) {
            value |= this.sideModes[i].ordinal() << i * 2;
        }
        return (short)value;
    }

    public void setSideModesFromShort(int value) {
        for (int i = 0; i < this.sideModes.length; ++i) {
            this.sideModes[i] = SideMode.getFromOrdinal(value & 3);
            value >>= 2;
        }
        if (value != 0) {
            throw new IllegalArgumentException("Did not apply cleanly: Rest " + value);
        }
    }

    private class SidedItemHandlerView
    implements IItemHandlerModifiable {
        private final Direction side;

        public SidedItemHandlerView(Direction side) {
            this.side = side;
        }

        public int getSlots() {
            return SidedProcessingSlotWrapper.this.inputHandler.getSlots() + SidedProcessingSlotWrapper.this.outputHandler.getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            if (slot < SidedProcessingSlotWrapper.this.inputHandler.getSlots()) {
                return SidedProcessingSlotWrapper.this.inputHandler.getStackInSlot(slot);
            }
            return SidedProcessingSlotWrapper.this.outputHandler.getStackInSlot(slot - SidedProcessingSlotWrapper.this.inputHandler.getSlots());
        }

        @Nonnull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!SidedProcessingSlotWrapper.this.getSideMode(this.side).isPullEnabled() || slot >= SidedProcessingSlotWrapper.this.inputHandler.getSlots()) {
                return stack;
            }
            return SidedProcessingSlotWrapper.this.inputHandler.insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!SidedProcessingSlotWrapper.this.getSideMode(this.side).isPushEnabled() || slot < SidedProcessingSlotWrapper.this.inputHandler.getSlots()) {
                return ItemStack.f_41583_;
            }
            return SidedProcessingSlotWrapper.this.outputHandler.extractItem(slot - SidedProcessingSlotWrapper.this.inputHandler.getSlots(), amount, simulate);
        }

        public int getSlotLimit(int slot) {
            if (slot < SidedProcessingSlotWrapper.this.inputHandler.getSlots()) {
                return SidedProcessingSlotWrapper.this.inputHandler.getSlotLimit(slot);
            }
            return SidedProcessingSlotWrapper.this.outputHandler.getSlotLimit(slot - SidedProcessingSlotWrapper.this.inputHandler.getSlots());
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot < SidedProcessingSlotWrapper.this.inputHandler.getSlots()) {
                return SidedProcessingSlotWrapper.this.inputHandler.isItemValid(slot, stack);
            }
            return SidedProcessingSlotWrapper.this.outputHandler.isItemValid(slot - SidedProcessingSlotWrapper.this.inputHandler.getSlots(), stack);
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            if (slot < SidedProcessingSlotWrapper.this.inputHandler.getSlots()) {
                SidedProcessingSlotWrapper.this.inputHandler.setStackInSlot(slot, stack);
            } else {
                SidedProcessingSlotWrapper.this.outputHandler.setStackInSlot(slot - SidedProcessingSlotWrapper.this.inputHandler.getSlots(), stack);
            }
        }
    }
}

