/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemylib.api.storage;

public enum SideMode {
    DISABLED(false, false),
    PULL(true, false),
    PUSH(false, true),
    ENABLED(true, true);

    private final boolean pullEnabled;
    private final boolean pushEnabled;
    private static final SideMode[] SIDE_MODES_VALUES;

    private SideMode(boolean pull, boolean push) {
        this.pullEnabled = pull;
        this.pushEnabled = push;
    }

    public boolean isPullEnabled() {
        return this.pullEnabled;
    }

    public boolean isPushEnabled() {
        return this.pushEnabled;
    }

    public static SideMode getFromOrdinal(int ordinal) {
        return SIDE_MODES_VALUES[ordinal];
    }

    static {
        SIDE_MODES_VALUES = SideMode.values();
    }
}

