/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled.integration;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.entangled.EntangledBlock;
import com.supermartijn642.entangled.EntangledBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin(value="entangled")
public class EntangledWailaPlugin
implements IBlockComponentProvider,
IWailaPlugin {
    public ResourceLocation getUid() {
        return new ResourceLocation("entangled", "entangled_block_component");
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IBlockComponentProvider)this, EntangledBlock.class);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockEntity tile = accessor.getBlockEntity();
        if (tile instanceof EntangledBlockEntity) {
            if (((EntangledBlockEntity)tile).isBound()) {
                BlockState boundBlockState = ((EntangledBlockEntity)tile).getBoundBlockState();
                MutableComponent boundBlock = (boundBlockState == null ? TextComponents.string((String)"Block") : TextComponents.blockState((BlockState)boundBlockState)).color(ChatFormatting.GOLD).get();
                BlockPos boundPos = ((EntangledBlockEntity)tile).getBoundBlockPos();
                MutableComponent x = TextComponents.string((String)Integer.toString(boundPos.m_123341_())).color(ChatFormatting.GOLD).get();
                MutableComponent y = TextComponents.string((String)Integer.toString(boundPos.m_123342_())).color(ChatFormatting.GOLD).get();
                MutableComponent z = TextComponents.string((String)Integer.toString(boundPos.m_123343_())).color(ChatFormatting.GOLD).get();
                if (((EntangledBlockEntity)tile).getBoundDimensionIdentifier() == accessor.getLevel().m_46472_()) {
                    tooltip.add((Component)TextComponents.translation((String)"entangled.waila.bound_same_dimension", (Object[])new Object[]{boundBlock, x, y, z}).get());
                } else {
                    MutableComponent dimension = TextComponents.dimension(((EntangledBlockEntity)tile).getBoundDimensionIdentifier()).color(ChatFormatting.GOLD).get();
                    tooltip.add((Component)TextComponents.translation((String)"entangled.waila.bound_other_dimension", (Object[])new Object[]{boundBlock, x, y, z, dimension}).get());
                }
                if (!((EntangledBlockEntity)tile).isBoundAndValid()) {
                    tooltip.add((Component)TextComponents.translation((String)"entangled.waila.invalid_block", (Object[])new Object[]{boundBlock}).color(ChatFormatting.RED).get());
                }
            } else {
                tooltip.add((Component)TextComponents.translation((String)"entangled.waila.unbound").get());
            }
        }
    }
}

