/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.RitualFluteHandler;
import ovh.corail.tombstone.network.CMessageRitualFluteValidationResult;
import ovh.corail.tombstone.network.PacketHandler;

public class SMessageRitualFluteValidation {
    private final int[] notes;

    public SMessageRitualFluteValidation(int[] notes) {
        this.notes = notes;
    }

    static SMessageRitualFluteValidation fromBytes(FriendlyByteBuf buf) {
        return new SMessageRitualFluteValidation(buf.m_130100_());
    }

    static void toBytes(SMessageRitualFluteValidation msg, FriendlyByteBuf buf) {
        buf.m_130089_(msg.notes);
    }

    public static class Handler {
        static void handle(final SMessageRitualFluteValidation message, Supplier<NetworkEvent.Context> contextSupplier) {
            final NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToServer(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        @Nullable ServerPlayer serverPlayer = ctx.getSender();
                        if (serverPlayer == null) {
                            return;
                        }
                        PacketHandler.sendToPlayer(new CMessageRitualFluteValidationResult(RitualFluteHandler.validateSequence(serverPlayer, message.notes)), serverPlayer);
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

