/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.teammetallurgy.aquaculture.entity.AquaFishingBobberEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class AquaBobberRenderer
extends EntityRenderer<AquaFishingBobberEntity> {
    private static final ResourceLocation BOBBER = new ResourceLocation("aquaculture", "textures/entity/rod/bobber/bobber.png");
    private static final ResourceLocation BOBBER_OVERLAY = new ResourceLocation("aquaculture", "textures/entity/rod/bobber/bobber_overlay.png");
    private static final ResourceLocation BOBBER_VANILLA = new ResourceLocation("aquaculture", "textures/entity/rod/bobber/bobber_vanilla.png");
    private static final ResourceLocation HOOK = new ResourceLocation("aquaculture", "textures/entity/rod/hook/hook.png");
    private static final RenderType BOBBER_RENDER = RenderType.m_110452_((ResourceLocation)BOBBER);
    private static final RenderType BOBBER_OVERLAY_RENDER = RenderType.m_110452_((ResourceLocation)BOBBER_OVERLAY);
    private static final RenderType BOBBER_VANILLA_RENDER = RenderType.m_110452_((ResourceLocation)BOBBER_VANILLA);
    private static final RenderType HOOK_RENDER = RenderType.m_110452_((ResourceLocation)HOOK);

    public AquaBobberRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(@Nonnull AquaFishingBobberEntity bobber, float entityYaw, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int i) {
        Player angler = bobber.m_37168_();
        if (angler != null) {
            DyeableLeatherItem lineItem;
            float anglerEye;
            double anglerZ;
            double anglerY;
            double anglerX;
            double fov;
            poseStack.m_85836_();
            poseStack.m_85836_();
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            poseStack.m_252781_(this.f_114476_.m_253208_());
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            PoseStack.Pose bobberMatrix = poseStack.m_85850_();
            Matrix4f posMatrix = bobberMatrix.m_252922_();
            Matrix3f matrix3f = bobberMatrix.m_252943_();
            VertexConsumer bobberOverlayVertex = bobber.hasBobber() ? buffer.m_6299_(BOBBER_OVERLAY_RENDER) : buffer.m_6299_(BOBBER_VANILLA_RENDER);
            ItemStack bobberStack = bobber.getBobber();
            float bobberR = 1.0f;
            float bobberG = 1.0f;
            float bobberB = 1.0f;
            if (!bobberStack.m_41619_() && bobberStack.m_41720_() instanceof DyeableLeatherItem) {
                int colorInt = ((DyeableLeatherItem)bobberStack.m_41720_()).m_41121_(bobberStack);
                bobberR = (float)(colorInt >> 16 & 0xFF) / 255.0f;
                bobberG = (float)(colorInt >> 8 & 0xFF) / 255.0f;
                bobberB = (float)(colorInt & 0xFF) / 255.0f;
            }
            AquaBobberRenderer.vertex(bobberOverlayVertex, posMatrix, matrix3f, i, 0.0f, 0, 0, 1, bobberR, bobberG, bobberB);
            AquaBobberRenderer.vertex(bobberOverlayVertex, posMatrix, matrix3f, i, 1.0f, 0, 1, 1, bobberR, bobberG, bobberB);
            AquaBobberRenderer.vertex(bobberOverlayVertex, posMatrix, matrix3f, i, 1.0f, 1, 1, 0, bobberR, bobberG, bobberB);
            AquaBobberRenderer.vertex(bobberOverlayVertex, posMatrix, matrix3f, i, 0.0f, 1, 0, 0, bobberR, bobberG, bobberB);
            if (bobber.hasBobber()) {
                VertexConsumer bobberVertex = buffer.m_6299_(BOBBER_RENDER);
                AquaBobberRenderer.renderPosTexture(bobberVertex, posMatrix, matrix3f, i, 0.0f, 0, 0, 1);
                AquaBobberRenderer.renderPosTexture(bobberVertex, posMatrix, matrix3f, i, 1.0f, 0, 1, 1);
                AquaBobberRenderer.renderPosTexture(bobberVertex, posMatrix, matrix3f, i, 1.0f, 1, 1, 0);
                AquaBobberRenderer.renderPosTexture(bobberVertex, posMatrix, matrix3f, i, 0.0f, 1, 0, 0);
            }
            VertexConsumer hookVertex = bobber.hasHook() ? buffer.m_6299_(RenderType.m_110452_((ResourceLocation)bobber.getHook().getTexture())) : buffer.m_6299_(HOOK_RENDER);
            AquaBobberRenderer.renderPosTexture(hookVertex, posMatrix, matrix3f, i, 0.0f, 0, 0, 1);
            AquaBobberRenderer.renderPosTexture(hookVertex, posMatrix, matrix3f, i, 1.0f, 0, 1, 1);
            AquaBobberRenderer.renderPosTexture(hookVertex, posMatrix, matrix3f, i, 1.0f, 1, 1, 0);
            AquaBobberRenderer.renderPosTexture(hookVertex, posMatrix, matrix3f, i, 0.0f, 1, 0, 0);
            poseStack.m_85849_();
            int hand = angler.m_5737_() == HumanoidArm.RIGHT ? 1 : -1;
            ItemStack heldMain = angler.m_21205_();
            if (!heldMain.canPerformAction(ToolActions.FISHING_ROD_CAST)) {
                hand = -hand;
            }
            float swingProgress = angler.m_21324_(partialTicks);
            float swingProgressSqrt = Mth.m_14031_((float)(Mth.m_14116_((float)swingProgress) * (float)Math.PI));
            float yawOffset = Mth.m_14179_((float)partialTicks, (float)angler.f_20884_, (float)angler.f_20883_) * ((float)Math.PI / 180);
            double sin = Mth.m_14031_((float)yawOffset);
            double cos = Mth.m_14089_((float)yawOffset);
            double handOffset = (double)hand * 0.35;
            if ((this.f_114476_.f_114360_ == null || this.f_114476_.f_114360_.m_92176_().m_90612_()) && angler == Minecraft.m_91087_().f_91074_) {
                fov = 960.0 / (double)((Integer)this.f_114476_.f_114360_.m_231837_().m_231551_()).intValue();
                Vec3 rod = this.f_114476_.f_114358_.m_167684_().m_167695_((float)hand * 0.525f, -0.1f);
                rod = rod.m_82490_(fov);
                rod = rod.m_82524_(swingProgressSqrt * 0.5f);
                rod = rod.m_82496_(-swingProgressSqrt * 0.7f);
                anglerX = Mth.m_14139_((double)partialTicks, (double)angler.f_19854_, (double)angler.m_20185_()) + rod.f_82479_;
                anglerY = Mth.m_14139_((double)partialTicks, (double)angler.f_19855_, (double)angler.m_20186_()) + rod.f_82480_;
                anglerZ = Mth.m_14139_((double)partialTicks, (double)angler.f_19856_, (double)angler.m_20189_()) + rod.f_82481_;
                anglerEye = angler.m_20192_();
            } else {
                anglerX = Mth.m_14139_((double)partialTicks, (double)angler.f_19854_, (double)angler.m_20185_()) - cos * handOffset - sin * 0.8;
                anglerY = angler.f_19855_ + (double)angler.m_20192_() + (angler.m_20186_() - angler.f_19855_) * (double)partialTicks - 0.45;
                anglerZ = Mth.m_14139_((double)partialTicks, (double)angler.f_19856_, (double)angler.m_20189_()) - sin * handOffset + cos * 0.8;
                anglerEye = angler.m_6047_() ? -0.1875f : 0.0f;
            }
            fov = Mth.m_14139_((double)partialTicks, (double)bobber.f_19854_, (double)bobber.m_20185_());
            double bobberY = Mth.m_14139_((double)partialTicks, (double)bobber.f_19855_, (double)bobber.m_20186_()) + 0.25;
            double bobberZ = Mth.m_14139_((double)partialTicks, (double)bobber.f_19856_, (double)bobber.m_20189_());
            float startX = (float)(anglerX - fov);
            float startY = (float)(anglerY - bobberY) + anglerEye;
            float startZ = (float)(anglerZ - bobberZ);
            VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_173247_());
            PoseStack.Pose pose = poseStack.m_85850_();
            ItemStack line = bobber.getFishingLine();
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            if (!line.m_41619_() && (lineItem = (DyeableLeatherItem)line.m_41720_()).m_41113_(line)) {
                int colorInt = lineItem.m_41121_(line);
                r = (float)(colorInt >> 16 & 0xFF) / 255.0f;
                g = (float)(colorInt >> 8 & 0xFF) / 255.0f;
                b = (float)(colorInt & 0xFF) / 255.0f;
            }
            for (int size = 0; size < 16; ++size) {
                AquaBobberRenderer.stringVertex(startX, startY, startZ, vertexConsumer, pose, AquaBobberRenderer.fraction(size, 15), AquaBobberRenderer.fraction(size + 1, 16), r, g, b);
            }
            poseStack.m_85849_();
            super.m_7392_((Entity)bobber, entityYaw, partialTicks, poseStack, buffer, i);
        }
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull AquaFishingBobberEntity fishHook) {
        return BOBBER_VANILLA;
    }

    private static void renderPosTexture(VertexConsumer builder, Matrix4f matrix4f, Matrix3f matrix3f, int i, float x, int y, int u, int v) {
        builder.m_252986_(matrix4f, x - 0.5f, (float)y - 0.5f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_((float)u, (float)v).m_86008_(OverlayTexture.f_118083_).m_85969_(i).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void vertex(VertexConsumer builder, Matrix4f matrix4f, Matrix3f matrix3f, int i, float x, int y, int u, int v, float r, float g, float b) {
        builder.m_252986_(matrix4f, x - 0.5f, (float)y - 0.5f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_((float)u, (float)v).m_86008_(OverlayTexture.f_118083_).m_85969_(i).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void stringVertex(float x, float y, float z, VertexConsumer vertexConsumer, PoseStack.Pose pose, float f1, float f2, float r, float g, float b) {
        float var7 = x * f1;
        float var8 = y * (f1 * f1 + f1) * 0.5f + 0.25f;
        float var9 = z * f1;
        float var10 = x * f2 - var7;
        float var11 = y * (f2 * f2 + f2) * 0.5f + 0.25f - var8;
        float var12 = z * f2 - var9;
        float var13 = Mth.m_14116_((float)(var10 * var10 + var11 * var11 + var12 * var12));
        vertexConsumer.m_252986_(pose.m_252922_(), var7, var8, var9).m_85950_(r, g, b, 1.0f).m_252939_(pose.m_252943_(), var10 /= var13, var11 /= var13, var12 /= var13).m_5752_();
    }

    private static float fraction(int value1, int value2) {
        return (float)value1 / (float)value2;
    }
}

