/*
 * Decompiled with CFR 0.152.
 */
package appbot.ae2;

import appbot.AppliedBotanics;
import appbot.Lookup;
import appbot.ae2.ManaKey;
import appbot.ae2.ManaKeyType;
import appeng.api.behaviors.StackImportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.networking.storage.IStorageService;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import vazkii.botania.api.mana.ManaReceiver;

public class ManaStorageImportStrategy
implements StackImportStrategy {
    private final Lookup<ManaReceiver, Direction> apiCache;
    private final Direction fromSide;

    public ManaStorageImportStrategy(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.apiCache = AppliedBotanics.getInstance().manaReceiver(level, fromPos);
        this.fromSide = fromSide;
    }

    public boolean transfer(StackTransferContext context) {
        if (!context.isKeyTypeEnabled(ManaKeyType.TYPE)) {
            return false;
        }
        ManaReceiver receiver = this.apiCache.find(this.fromSide);
        if (receiver == null) {
            return false;
        }
        long remainingTransferAmount = (long)context.getOperationsRemaining() * (long)ManaKeyType.TYPE.getAmountPerOperation();
        IStorageService inv = context.getInternalStorage();
        int amount = (int)Math.min(remainingTransferAmount, (long)receiver.getCurrentMana());
        if (amount <= 0) {
            return false;
        }
        int inserted = (int)inv.getInventory().insert(ManaKey.KEY, (long)amount, Actionable.MODULATE, context.getActionSource());
        receiver.receiveMana(-inserted);
        int opsUsed = Math.max(1, inserted / ManaKeyType.TYPE.getAmountPerOperation());
        context.reduceOperationsRemaining((long)opsUsed);
        return true;
    }
}

