/*
 * Decompiled with CFR 0.152.
 */
package appbot.ae2;

import appbot.AppliedBotanics;
import appbot.Lookup;
import appbot.ae2.ManaHelper;
import appbot.ae2.ManaKey;
import appeng.api.behaviors.StackExportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import com.google.common.primitives.Ints;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import vazkii.botania.api.mana.ManaReceiver;

public class ManaStorageExportStrategy
implements StackExportStrategy {
    private final Lookup<ManaReceiver, Direction> apiCache;
    private final Direction fromSide;

    public ManaStorageExportStrategy(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.apiCache = AppliedBotanics.getInstance().manaReceiver(level, fromPos);
        this.fromSide = fromSide;
    }

    public long transfer(StackTransferContext context, AEKey what, long amount) {
        double energyFactor;
        IActionSource src;
        AEKey request;
        MEStorage inv;
        long retrieved;
        if (!(what instanceof ManaKey)) {
            return 0L;
        }
        ManaReceiver receiver = this.apiCache.find(this.fromSide);
        if (receiver == null) {
            return 0L;
        }
        IEnergySource energy = context.getEnergySource();
        double availablePower = energy.extractAEPower((double)(retrieved = (inv = context.getInternalStorage().getInventory()).extract(request = ManaKey.KEY, amount, Actionable.SIMULATE, src = context.getActionSource())) / (energyFactor = Math.max(1.0, (double)request.getAmountPerOperation())), Actionable.SIMULATE, PowerMultiplier.CONFIG);
        int itemToExtract = (int)Math.min((long)(availablePower * energyFactor + 0.9), retrieved);
        if (itemToExtract == 0) {
            return 0L;
        }
        int prevMana = receiver.getCurrentMana();
        receiver.receiveMana(itemToExtract);
        int inserted = Math.abs(receiver.getCurrentMana() - prevMana);
        if (inserted == 0) {
            inserted = itemToExtract;
        }
        energy.extractAEPower((double)inserted / energyFactor, Actionable.MODULATE, PowerMultiplier.CONFIG);
        return inv.extract(request, (long)inserted, Actionable.MODULATE, src);
    }

    public long push(AEKey what, long amount, Actionable mode) {
        if (!(what instanceof ManaKey)) {
            return 0L;
        }
        ManaReceiver receiver = this.apiCache.find(this.fromSide);
        if (receiver == null || receiver.isFull()) {
            return 0L;
        }
        int amt = Ints.saturatedCast((long)amount);
        int prevMana = receiver.getCurrentMana();
        if (mode != Actionable.MODULATE) {
            return Math.min(amt, ManaHelper.getCapacity(receiver) - prevMana);
        }
        receiver.receiveMana(amt);
        int inserted = Math.abs(receiver.getCurrentMana() - prevMana);
        if (inserted == 0) {
            inserted = amt;
        }
        return inserted;
    }
}

