/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.blocks;

import com.thevortex.allthemodium.AllTheModium;
import com.thevortex.allthemodium.reference.TweakProxy;
import com.thevortex.allthemodium.registry.LevelRegistry;
import com.thevortex.allthemodium.registry.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TeleportPad
extends Block {
    protected static final VoxelShape TELEPORTPAD_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    protected static final String MINING = "allthemodium:mining";
    protected static final String THE_OTHER = "allthemodium:the_other";
    protected static final String THE_BEYOND = "allthemodium:the_beyond";
    protected static final String THE_END = "minecraft:the_end";
    protected static final String NETHER = "minecraft:the_nether";
    protected static final String OVERWORLD = "minecraft:overworld";
    protected Integer lastTeleport = 0;

    public TeleportPad(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player instanceof ServerPlayer && player.m_6047_()) {
            this.transferPlayer((ServerPlayer)player, pos);
            worldIn.m_7107_((ParticleOptions)ParticleTypes.f_123745_, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), 0.0, 1.0, 0.0);
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public void transferPlayer(ServerPlayer player, BlockPos pos) {
        int config = TweakProxy.packMode();
        AllTheModium.LOGGER.info("Config Value: " + config);
        switch (player.m_9236_().m_46472_().m_135782_().toString()) {
            case "minecraft:overworld": {
                this.teleport(LevelRegistry.Mining, player, pos, player.f_8924_.m_129921_());
                break;
            }
            case "allthemodium:mining": {
                this.teleport(AllTheModium.OverWorld, player, pos, player.f_8924_.m_129921_());
                break;
            }
            case "minecraft:the_nether": {
                this.teleport(LevelRegistry.THE_OTHER, player, pos, player.f_8924_.m_129921_());
                break;
            }
            case "allthemodium:the_other": {
                switch (config) {
                    case 5: {
                        this.teleport(AllTheModium.The_End, player, pos, player.f_8924_.m_129921_());
                        break;
                    }
                    default: {
                        this.teleport(AllTheModium.Nether, player, pos, player.f_8924_.m_129921_());
                    }
                }
            }
            case "minecraft:the_end": {
                switch (config) {
                    case 5: {
                        this.teleport(LevelRegistry.THE_OTHER, player, pos, player.f_8924_.m_129921_());
                        break;
                    }
                    default: {
                        this.teleport(LevelRegistry.THE_BEYOND, player, pos, player.f_8924_.m_129921_());
                    }
                }
            }
            case "allthemodium:the_beyond": {
                this.teleport(AllTheModium.The_End, player, pos, player.f_8924_.m_129921_());
            }
        }
    }

    private void teleport(ResourceKey<Level> destination, ServerPlayer player, BlockPos pos, Integer tickCount) {
        int y;
        if (this.lastTeleport == 0) {
            this.lastTeleport = tickCount - 25;
        }
        if (tickCount - this.lastTeleport < 20) {
            return;
        }
        ServerLevel targetWorld = player.f_8924_.m_129880_(destination);
        boolean located = false;
        for (y = 256; y >= 1; --y) {
            BlockPos posa = new BlockPos(Math.round(pos.m_123341_()), y, Math.round(pos.m_123343_()));
            Block potential = targetWorld.m_8055_(posa).m_60734_();
            if (!potential.m_49954_().toString().contains("teleport_pad")) continue;
            located = true;
            break;
        }
        if (located) {
            targetWorld.m_7106_((ParticleOptions)ParticleTypes.f_123745_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 0.0, 1.0, 0.0);
            player.m_8999_(targetWorld, (double)pos.m_123341_() + 0.5, (double)y + 0.25, (double)pos.m_123343_() + 0.5, player.f_20928_, player.f_20901_);
            this.lastTeleport = tickCount;
            return;
        }
        if (!targetWorld.m_8055_(pos).m_155947_() && targetWorld.m_8055_(pos).canEntityDestroy((BlockGetter)targetWorld, pos, (Entity)player)) {
            targetWorld.m_46597_(pos, ((Block)ModRegistry.TELEPORT_PAD.get()).m_49966_());
        }
        targetWorld.m_7106_((ParticleOptions)ParticleTypes.f_123745_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 0.0, 1.0, 0.0);
        player.m_8999_(targetWorld, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.25, (double)pos.m_123343_() + 0.5, player.f_20928_, player.f_20901_);
        this.lastTeleport = tickCount;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return TELEPORTPAD_AABB;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return TELEPORTPAD_AABB;
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        return !player.m_9236_().m_46472_().m_211136_().m_135827_().contains("allthemodium");
    }
}

