/*
 * Decompiled with CFR 0.152.
 */
package mod.motivationaldragon.potionblender.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import mod.motivationaldragon.potionblender.Constants;
import mod.motivationaldragon.potionblender.utils.ModUtils;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import org.jetbrains.annotations.NotNull;

public class PotionEffectMerger {
    public static List<MobEffectInstance> mergeCombinableEffects(List<MobEffectInstance> effectInstances, double decayRate) {
        if (decayRate == 0.0) {
            decayRate = 1.0;
            Constants.LOG.error("Decay rate was set to 0, using default value of 1 to avoid division by 0");
        }
        HashSet<MobEffect> mergedStatusEffects = new HashSet<MobEffect>();
        ArrayList<MobEffectInstance> finalPotionStatusEffects = new ArrayList<MobEffectInstance>(effectInstances);
        for (int i = 0; i < finalPotionStatusEffects.size(); ++i) {
            MobEffectInstance effectInstance1 = (MobEffectInstance)finalPotionStatusEffects.get(i);
            ArrayList<MobEffectInstance> combinableEffects = new ArrayList<MobEffectInstance>();
            int totalDuration = effectInstance1.m_19557_();
            combinableEffects.add(effectInstance1);
            for (int j = 0; j < finalPotionStatusEffects.size(); ++j) {
                MobEffectInstance effectInstance2 = (MobEffectInstance)finalPotionStatusEffects.get(j);
                if (i == j || mergedStatusEffects.contains(effectInstance1.m_19544_()) || !PotionEffectMerger.areEffectsDurationsAddable(effectInstance1, effectInstance2)) continue;
                totalDuration += (int)(1.0 / decayRate * (double)effectInstance2.m_19557_());
                decayRate += 1.0;
                combinableEffects.add(effectInstance2);
            }
            mergedStatusEffects.add(effectInstance1.m_19544_());
            if (combinableEffects.size() <= 1) continue;
            MobEffectInstance combinedEffect = ModUtils.copyEffectWithNewDuration((MobEffectInstance)combinableEffects.get(0), totalDuration);
            finalPotionStatusEffects.removeAll(combinableEffects);
            finalPotionStatusEffects.add(combinedEffect);
        }
        return finalPotionStatusEffects;
    }

    @NotNull
    public static List<MobEffectInstance> mergeLingeringPotionEffects(List<MobEffectInstance> finalPotionStatusEffects) {
        ArrayList<MobEffectInstance> lingeringEffects = new ArrayList<MobEffectInstance>(finalPotionStatusEffects.size());
        for (MobEffectInstance effectInstance : finalPotionStatusEffects) {
            if (effectInstance.m_19544_().m_8093_()) {
                lingeringEffects.add(new MobEffectInstance(effectInstance.m_19544_(), effectInstance.m_19557_(), Math.round((float)effectInstance.m_19564_() * 0.5f), effectInstance.m_19571_(), effectInstance.m_19572_(), effectInstance.m_19575_()));
                continue;
            }
            lingeringEffects.add(ModUtils.copyEffectWithNewDuration(effectInstance, Math.round((float)effectInstance.m_19557_() * 0.25f)));
        }
        return lingeringEffects;
    }

    private static boolean areEffectsDurationsAddable(MobEffectInstance effectInstance1, MobEffectInstance effectInstance2) {
        return effectInstance1.m_19544_() == effectInstance2.m_19544_() && effectInstance1.m_19564_() == effectInstance2.m_19564_();
    }

    public static boolean wouldIgnoreInstantPotion(ItemStack potion, List<MobEffectInstance> cauldronInventoryEffects) {
        List<MobEffectInstance> effectInstances = PotionUtils.m_43547_((ItemStack)potion);
        effectInstances = effectInstances.stream().filter(e -> e.m_19544_().m_8093_()).toList();
        return cauldronInventoryEffects.stream().anyMatch(effectInstances::contains);
    }
}

