/*
 * Decompiled with CFR 0.152.
 */
package mod.motivationaldragon.potionblender.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.IntStream;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BrewingCauldronRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final boolean usePotionMergingRules;
    private final int color;
    private final double decayRate;
    private final boolean isOrdered;
    private final int brewingTime;
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack output;

    public BrewingCauldronRecipe(ResourceLocation id, int brewingTime, boolean usePotionMergingRules, int color, boolean isOrdered, double decayRate, NonNullList<Ingredient> ingredients, ItemStack output) {
        if (usePotionMergingRules && !(output.m_41720_() instanceof PotionItem)) {
            throw new IllegalArgumentException("Output must be a potion if usePotionMergingRules is true");
        }
        if (usePotionMergingRules) {
            for (Ingredient ingredient : ingredients) {
                for (ItemStack stack : ingredient.m_43908_()) {
                    if (!(stack.m_41720_() instanceof PotionItem)) continue;
                    stack.m_41714_((Component)Component.m_237115_((String)"potionblender.recipe.potion_wildcard_names"));
                    stack.m_41663_(null, 0);
                }
            }
            output.m_41714_((Component)Component.m_237115_((String)"potionblender.recipe.merged_potion_wildcard_names"));
            output.m_41663_(null, 0);
        }
        this.id = id;
        this.ingredients = ingredients;
        this.brewingTime = brewingTime;
        this.color = color;
        this.decayRate = decayRate;
        this.isOrdered = isOrdered;
        this.usePotionMergingRules = usePotionMergingRules;
        this.output = output;
    }

    public boolean m_5818_(@NotNull Container container, @NotNull Level level) {
        if (level.m_5776_()) {
            return false;
        }
        if (container.m_6643_() != this.ingredients.size()) {
            return false;
        }
        if (this.isOrdered) {
            return IntStream.range(0, this.ingredients.size()).allMatch(i -> ((Ingredient)this.ingredients.get(i)).test(container.m_8020_(i)));
        }
        return this.ingredients.stream().allMatch(ingredient -> IntStream.range(0, container.m_6643_()).anyMatch(i -> ingredient.test(container.m_8020_(i))));
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container var1, @NotNull RegistryAccess var2) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int var1, int var2) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess var1) {
        return this.output;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return CauldronRecipeSerializer.INSTANCE;
    }

    public int getBrewingTime() {
        return this.brewingTime;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public int getColor() {
        return this.color;
    }

    public boolean isOrdered() {
        return this.isOrdered;
    }

    public boolean usePotionMeringRules() {
        return this.usePotionMergingRules;
    }

    public double getDecayRate() {
        return this.decayRate;
    }

    public static class CauldronRecipeSerializer
    implements RecipeSerializer<BrewingCauldronRecipe> {
        public static final CauldronRecipeSerializer INSTANCE = new CauldronRecipeSerializer();

        @NotNull
        public BrewingCauldronRecipe fromJson(@NotNull ResourceLocation resourceLocation, JsonObject jsonObject) {
            int brewingTime = jsonObject.get("brewingTime").getAsInt();
            boolean usePotionMergingRules = jsonObject.get("usePotionMergingRules").getAsBoolean();
            int color = jsonObject.has("color") ? jsonObject.get("color").getAsInt() : 0;
            boolean isOrdered = jsonObject.has("isOrdered") && jsonObject.get("isOrdered").getAsBoolean();
            JsonArray ingredientAsJson = jsonObject.getAsJsonArray("ingredients");
            NonNullList ingredients = NonNullList.m_122780_((int)ingredientAsJson.size(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                ingredients.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredientAsJson.get(i)));
            }
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)jsonObject.getAsJsonObject("output"));
            return new BrewingCauldronRecipe(resourceLocation, brewingTime, usePotionMergingRules, color, isOrdered, 1.0, (NonNullList<Ingredient>)ingredients, output);
        }

        @NotNull
        public BrewingCauldronRecipe fromNetwork(@NotNull ResourceLocation resourceLocation, FriendlyByteBuf buff) {
            int brewingTime = buff.readInt();
            boolean usePotionMergingRules = buff.readBoolean();
            int color = buff.readInt();
            boolean isOrdered = buff.readBoolean();
            double decayRate = buff.readDouble();
            NonNullList ingredients = NonNullList.m_122780_((int)buff.readInt(), (Object)Ingredient.f_43901_);
            ingredients.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buff));
            ItemStack output = buff.m_130267_();
            return new BrewingCauldronRecipe(resourceLocation, brewingTime, usePotionMergingRules, color, isOrdered, decayRate, (NonNullList<Ingredient>)ingredients, output);
        }

        public void toNetwork(FriendlyByteBuf buff, BrewingCauldronRecipe brewingCauldronRecipe) {
            buff.writeInt(brewingCauldronRecipe.brewingTime);
            buff.writeBoolean(brewingCauldronRecipe.usePotionMergingRules);
            buff.writeInt(brewingCauldronRecipe.color);
            buff.writeBoolean(brewingCauldronRecipe.isOrdered);
            buff.writeDouble(brewingCauldronRecipe.decayRate);
            NonNullList<Ingredient> recipeIngredients = brewingCauldronRecipe.m_7527_();
            buff.writeInt(recipeIngredients.size());
            for (Ingredient ingredient : recipeIngredients) {
                ingredient.m_43923_(buff);
            }
            buff.m_130055_(brewingCauldronRecipe.output);
        }
    }

    public static class Type
    implements RecipeType<BrewingCauldronRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "brewing_cauldron_recipe";
    }
}

