/*
 * Decompiled with CFR 0.152.
 */
package mod.motivationaldragon.potionblender.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import mod.motivationaldragon.potionblender.block.BrewingCauldron;
import mod.motivationaldragon.potionblender.blockentities.BrewingCauldronBlockEntity;
import mod.motivationaldragon.potionblender.utils.ModUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class BrewingCauldronRenderer
implements BlockEntityRenderer<BrewingCauldronBlockEntity> {
    private static final Material WATER_MATERIAL = new Material(InventoryMenu.f_39692_, new ResourceLocation("block/water_still"));

    public BrewingCauldronRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(BrewingCauldronBlockEntity brewingCauldronBlock, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
        NonNullList<ItemStack> inventory = brewingCauldronBlock.getInventory();
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stack = (ItemStack)inventory.get(i);
            if (stack.m_41619_()) continue;
            poseStack.m_85836_();
            float percentageOfInventoryIterated = (float)i / (float)inventory.size();
            poseStack.m_85837_(0.5, (double)ModUtils.lerp(0.5f, 0.8f, percentageOfInventoryIterated), 0.5);
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)i * 27.0f));
            renderer.m_269128_(stack, ItemDisplayContext.FIXED, packedLight, OverlayTexture.f_118083_, poseStack, bufferSource, brewingCauldronBlock.m_58904_(), 0);
            poseStack.m_85849_();
        }
        if (Boolean.TRUE.equals(brewingCauldronBlock.m_58900_().m_61143_((Property)BrewingCauldron.HAS_FLUID))) {
            int waterColor = brewingCauldronBlock.getWaterColor();
            int red = waterColor >> 16 & 0xFF;
            int green = waterColor >> 8 & 0xFF;
            int blue = waterColor & 0xFF;
            int alpha = 190;
            TextureAtlasSprite water = WATER_MATERIAL.m_119204_();
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 1.0f, 0.0f);
            VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110469_());
            Matrix4f matrix = poseStack.m_85850_().m_252922_();
            float sizeFactor = 0.875f;
            float maxV = (water.m_118412_() - water.m_118411_()) * sizeFactor;
            float minV = (water.m_118412_() - water.m_118411_()) * (1.0f - sizeFactor);
            float cauldronFullness = (float)brewingCauldronBlock.getNumberOfItems() / (float)brewingCauldronBlock.getInventory().size();
            float maxHeight = 0.4f;
            float minHeight = 0.5f;
            float height = -minHeight + cauldronFullness * maxHeight;
            consumer.m_252986_(matrix, sizeFactor, height, 1.0f - sizeFactor).m_6122_(red, green, blue, alpha).m_7421_(water.m_118409_(), water.m_118411_() + maxV).m_85969_(packedLight).m_86008_(packedOverlay).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
            consumer.m_252986_(matrix, 1.0f - sizeFactor, height, 1.0f - sizeFactor).m_6122_(red, green, blue, alpha).m_7421_(water.m_118410_(), water.m_118411_() + maxV).m_85969_(packedLight).m_86008_(packedOverlay).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
            consumer.m_252986_(matrix, 1.0f - sizeFactor, height, sizeFactor).m_6122_(red, green, blue, alpha).m_7421_(water.m_118410_(), water.m_118411_() + minV).m_85969_(packedLight).m_86008_(packedOverlay).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
            consumer.m_252986_(matrix, sizeFactor, height, sizeFactor).m_6122_(red, green, blue, alpha).m_7421_(water.m_118409_(), water.m_118411_() + minV).m_85969_(packedLight).m_86008_(packedOverlay).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
            poseStack.m_85849_();
        }
    }
}

