/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queryparser.surround.query;

import guideme.internal.shaded.lucene.index.IndexReader;
import guideme.internal.shaded.lucene.index.MultiTerms;
import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.queryparser.surround.query.SimpleTerm;
import guideme.internal.shaded.lucene.util.BytesRef;
import java.io.IOException;

public class SrndTermQuery
extends SimpleTerm {
    private final String termText;

    public SrndTermQuery(String termText, boolean quoted) {
        super(quoted);
        this.termText = termText;
    }

    public String getTermText() {
        return this.termText;
    }

    public Term getLuceneTerm(String fieldName) {
        return new Term(fieldName, this.getTermText());
    }

    @Override
    public String toStringUnquoted() {
        return this.getTermText();
    }

    @Override
    public void visitMatchingTerms(IndexReader reader, String fieldName, SimpleTerm.MatchingTermVisitor mtv) throws IOException {
        TermsEnum termsEnum;
        TermsEnum.SeekStatus status;
        Terms terms = MultiTerms.getTerms(reader, fieldName);
        if (terms != null && (status = (termsEnum = terms.iterator()).seekCeil(new BytesRef(this.getTermText()))) == TermsEnum.SeekStatus.FOUND) {
            mtv.visitMatchingTerm(this.getLuceneTerm(fieldName));
        }
    }
}

