/*
 * Decompiled with CFR 0.152.
 */
package giselle.jei_mekanism_multiblocks.client.jei.category;

import giselle.jei_mekanism_multiblocks.client.gui.IntSliderWidget;
import giselle.jei_mekanism_multiblocks.client.gui.IntSliderWithButtons;
import giselle.jei_mekanism_multiblocks.client.jei.MultiblockCategory;
import giselle.jei_mekanism_multiblocks.client.jei.MultiblockWidget;
import giselle.jei_mekanism_multiblocks.client.jei.ResultWidget;
import giselle.jei_mekanism_multiblocks.client.jei.category.ICostConsumer;
import java.util.function.Consumer;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.util.text.TextUtils;
import mezz.jei.api.helpers.IGuiHelper;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class MatrixCategory
extends MultiblockCategory<MatrixWidget> {
    public MatrixCategory(IGuiHelper helper) {
        super(helper, Mekanism.rl((String)"matrix"), MatrixWidget.class, (Component)MekanismLang.MATRIX.translate(new Object[0]), MekanismBlocks.INDUCTION_PORT.getItemStack());
    }

    @Override
    protected void getRecipeCatalystItemStacks(Consumer<ItemStack> consumer) {
        super.getRecipeCatalystItemStacks(consumer);
        consumer.accept(MekanismBlocks.INDUCTION_CASING.getItemStack());
        consumer.accept(MekanismBlocks.INDUCTION_PORT.getItemStack());
        consumer.accept(MekanismBlocks.STRUCTURAL_GLASS.getItemStack());
        consumer.accept(MekanismBlocks.BASIC_INDUCTION_CELL.getItemStack());
        consumer.accept(MekanismBlocks.BASIC_INDUCTION_PROVIDER.getItemStack());
        consumer.accept(MekanismBlocks.ADVANCED_INDUCTION_CELL.getItemStack());
        consumer.accept(MekanismBlocks.ADVANCED_INDUCTION_PROVIDER.getItemStack());
        consumer.accept(MekanismBlocks.ELITE_INDUCTION_CELL.getItemStack());
        consumer.accept(MekanismBlocks.ELITE_INDUCTION_PROVIDER.getItemStack());
        consumer.accept(MekanismBlocks.ULTIMATE_INDUCTION_CELL.getItemStack());
        consumer.accept(MekanismBlocks.ULTIMATE_INDUCTION_PROVIDER.getItemStack());
    }

    public static class MatrixWidget
    extends MultiblockWidget {
        protected IntSliderWithButtons portsWidget;

        @Override
        protected void collectOtherConfigs(Consumer<AbstractWidget> consumer) {
            super.collectOtherConfigs(consumer);
            this.portsWidget = new IntSliderWithButtons(0, 0, 0, 0, "text.jei_mekanism_multiblocks.specs.ports", 0, 2, 0);
            consumer.accept(this.portsWidget);
            ((IntSliderWidget)((Object)this.portsWidget.getSlider())).addValueChangeHanlder(this::onPortsChanged);
            this.updatePortsSliderLimit();
        }

        @Override
        public void load(CompoundTag tag) {
            super.load(tag);
            this.setPortCount(tag.m_128451_("PortCount"));
        }

        @Override
        public void save(CompoundTag tag) {
            super.save(tag);
            tag.m_128405_("PortCount", this.getPortCount());
        }

        @Override
        protected void collectCost(ICostConsumer consumer) {
            super.collectCost(consumer);
            int corners = this.getCornerBlocks();
            int sides = this.getSideBlocks();
            int ports = this.getPortCount();
            sides -= ports;
            int casing = 0;
            int glasses = 0;
            if (this.isUseGlass()) {
                casing = corners;
                glasses = sides;
            } else {
                casing = corners + sides;
                glasses = 0;
            }
            consumer.accept(new ItemStack((ItemLike)MekanismBlocks.INDUCTION_CASING, casing));
            consumer.accept(new ItemStack((ItemLike)MekanismBlocks.INDUCTION_PORT, ports));
            consumer.accept(new ItemStack((ItemLike)this.getGlassBlock(), glasses));
        }

        @Override
        protected void collectResult(Consumer<AbstractWidget> consumer) {
            super.collectResult(consumer);
            int innerVolume = this.getDimensionInnerVolume();
            consumer.accept(new ResultWidget((Component)Component.m_237115_((String)"text.jei_mekanism_multiblocks.result.inner_volume"), (Component)Component.m_237110_((String)"text.jei_mekanism_multiblocks.result.blocks", (Object[])new Object[]{TextUtils.format((long)innerVolume)})));
        }

        @Override
        protected void onDimensionChanged() {
            super.onDimensionChanged();
            this.updatePortsSliderLimit();
        }

        public void updatePortsSliderLimit() {
            IntSliderWidget portsSlider = (IntSliderWidget)((Object)this.portsWidget.getSlider());
            int ports = portsSlider.getValue();
            portsSlider.setMaxValue(this.getSideBlocks());
            portsSlider.setValue(ports);
        }

        protected void onPortsChanged(int ports) {
            this.markNeedUpdate();
        }

        public int getPortCount() {
            return ((IntSliderWidget)((Object)this.portsWidget.getSlider())).getValue();
        }

        public void setPortCount(int portCount) {
            ((IntSliderWidget)((Object)this.portsWidget.getSlider())).setValue(portCount);
        }

        @Override
        public int getDimensionWidthMin() {
            return 3;
        }

        @Override
        public int getDimensionWidthMax() {
            return 18;
        }

        @Override
        public int getDimensionLengthMin() {
            return 3;
        }

        @Override
        public int getDimensionLengthMax() {
            return 18;
        }

        @Override
        public int getDimensionHeightMin() {
            return 3;
        }

        @Override
        public int getDimensionHeightMax() {
            return 18;
        }

        @Override
        public Block getGlassBlock() {
            return MekanismBlocks.STRUCTURAL_GLASS.getBlock();
        }
    }
}

